/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.structures;

import WayofTime.bloodmagic.gson.Serializers;
import WayofTime.bloodmagic.structures.DungeonRoom;
import WayofTime.bloodmagic.structures.DungeonRoomRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class DungeonRoomLoader {
    public static void saveDungeons() {
        for (DungeonRoom room : DungeonRoomRegistry.dungeonWeightMap.keySet()) {
            DungeonRoomLoader.saveSingleDungeon(room);
        }
    }

    public static void saveSingleDungeon(DungeonRoom room) {
        String json = Serializers.GSON.toJson((Object)room);
        try {
            File file = new File("config/BloodMagic/schematics");
            file.mkdirs();
            FileWriter writer = new FileWriter("config/BloodMagic/schematics/" + new Random().nextInt() + ".json");
            writer.write(json);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadDungeons() {
        try {
            URL schematicURL = DungeonRoomLoader.class.getResource(DungeonRoomLoader.resLocToResourcePath(new ResourceLocation("bloodmagic:schematics")));
            List schematics = (List)Serializers.GSON.fromJson(Resources.toString((URL)schematicURL, (Charset)Charsets.UTF_8), new TypeToken<List<String>>(){}.getType());
            for (String schematicKey : schematics) {
                ResourceLocation schematic = new ResourceLocation(schematicKey);
                URL dungeonURL = DungeonRoomLoader.class.getResource(DungeonRoomLoader.resLocToResourcePath(schematic));
                DungeonRoom dungeonRoom = (DungeonRoom)Serializers.GSON.fromJson(Resources.toString((URL)dungeonURL, (Charset)Charsets.UTF_8), DungeonRoom.class);
                DungeonRoomRegistry.registerDungeonRoom(dungeonRoom, Math.max(1, dungeonRoom.dungeonWeight));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void test() {
        ResourceLocation id = new ResourceLocation("bloodmagic", "testGson");
        String s = id.func_110624_b();
        String s1 = id.func_110623_a();
        InputStream inputstream = null;
        try {
            inputstream = DungeonRoomLoader.class.getResourceAsStream("/assets/" + s + "/schematics/" + s1 + ".nbt");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputstream);
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(inputstream);
                throw throwable2;
            }
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return;
    }

    public static String resLocToResourcePath(ResourceLocation resourceLocation) {
        return "/assets/" + resourceLocation.func_110624_b() + "/schematics/" + resourceLocation.func_110623_a() + ".json";
    }
}

