/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.block.BlockDemonCrystal;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.soul.DemonWillHolder;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.tile.base.TileTicking;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class TileDemonCrystal
extends TileTicking {
    public static final double sameWillConversionRate = 50.0;
    public static final double defaultWillConversionRate = 100.0;
    public static final double timeDelayForWrongWill = 0.6;
    public final int maxWill = 100;
    public final double drainRate = 1.0;
    public DemonWillHolder holder = new DemonWillHolder();
    public double progressToNextCrystal = 0.0;
    public int internalCounter = 0;
    public int crystalCount = 1;
    public EnumFacing placement = EnumFacing.UP;

    @Override
    public void onUpdate() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ++this.internalCounter;
        if (this.internalCounter % 20 == 0 && this.crystalCount < 7) {
            EnumDemonWillType type = this.getType();
            double value = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, type);
            if (type != EnumDemonWillType.DEFAULT) {
                if (value >= 0.5) {
                    double nextProgress = this.getCrystalGrowthPerSecond(value);
                    this.progressToNextCrystal += WorldDemonWillHandler.drainWill(this.func_145831_w(), this.func_174877_v(), type, nextProgress * 50.0, true) / 50.0;
                } else {
                    value = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, EnumDemonWillType.DEFAULT);
                    if (value > 0.5) {
                        double nextProgress = this.getCrystalGrowthPerSecond(value) * 0.6;
                        this.progressToNextCrystal += WorldDemonWillHandler.drainWill(this.func_145831_w(), this.func_174877_v(), EnumDemonWillType.DEFAULT, nextProgress * 100.0, true) / 100.0;
                    }
                }
            } else if (value > 0.5) {
                double nextProgress = this.getCrystalGrowthPerSecond(value);
                this.progressToNextCrystal += WorldDemonWillHandler.drainWill(this.func_145831_w(), this.func_174877_v(), type, nextProgress * 50.0, true) / 50.0;
            }
            this.checkAndGrowCrystal();
        }
    }

    public double growCrystalWithWillAmount(double willDrain, double progressPercentage) {
        double percentDrain;
        if (this.crystalCount >= 7) {
            return 0.0;
        }
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        int meta = this.func_145838_q().func_176201_c(state);
        EnumDemonWillType type = EnumDemonWillType.values()[meta];
        double value = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, type);
        double d = percentDrain = willDrain <= 0.0 ? 1.0 : Math.min(1.0, value / willDrain);
        if (percentDrain <= 0.0) {
            return 0.0;
        }
        WorldDemonWillHandler.drainWill(this.func_145831_w(), this.field_174879_c, type, percentDrain * willDrain, true);
        this.progressToNextCrystal += percentDrain * progressPercentage;
        this.checkAndGrowCrystal();
        return percentDrain * progressPercentage;
    }

    public EnumDemonWillType getType() {
        return EnumDemonWillType.values()[this.func_145832_p()];
    }

    public void checkAndGrowCrystal() {
        if (this.progressToNextCrystal >= 1.0 && this.internalCounter % 100 == 0) {
            this.progressToNextCrystal -= 1.0;
            ++this.crystalCount;
            this.func_70296_d();
            this.notifyUpdate();
        }
    }

    public double getMaxWillForCrystal() {
        return 50.0;
    }

    public boolean dropSingleCrystal() {
        IBlockState state;
        EnumDemonWillType type;
        ItemStack stack;
        if (!this.func_145831_w().field_72995_K && this.crystalCount > 1 && !(stack = BlockDemonCrystal.getItemStackDropped(type = (EnumDemonWillType)((Object)(state = this.func_145831_w().func_180495_p(this.field_174879_c)).func_177229_b(BlockDemonCrystal.TYPE)), 1)).func_190926_b()) {
            --this.crystalCount;
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack);
            this.notifyUpdate();
            return true;
        }
        return false;
    }

    public double getCrystalGrowthPerSecond(double will) {
        return 0.005 * Math.sqrt(will / 200.0);
    }

    public int getCrystalCountForRender() {
        return MathHelper.func_76125_a((int)(this.crystalCount - 1), (int)0, (int)6);
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        this.holder.readFromNBT(tag, "Will");
        this.crystalCount = tag.func_74762_e("crystalCount");
        this.placement = EnumFacing.func_82600_a((int)tag.func_74762_e("placement"));
        this.progressToNextCrystal = tag.func_74769_h("progress");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        this.holder.writeToNBT(tag, "Will");
        tag.func_74768_a("crystalCount", this.crystalCount);
        tag.func_74768_a("placement", this.placement.func_176745_a());
        tag.func_74780_a("progress", this.progressToNextCrystal);
        return tag;
    }

    public int getCrystalCount() {
        return this.crystalCount;
    }

    public void setCrystalCount(int crystalCount) {
        this.crystalCount = crystalCount;
    }

    public EnumFacing getPlacement() {
        return this.placement;
    }

    public void setPlacement(EnumFacing placement) {
        this.placement = placement;
    }

    @Override
    protected void onDataPacketClientReceived() {
        super.onDataPacketClientReceived();
        this.notifyUpdate();
    }
}

