/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.programmer;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.rftoolscontrol.blocks.programmer.ProgrammerTileEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketUpdateNBTItemInventoryProgrammer
implements IMessage {
    public BlockPos pos;
    public int slotIndex;
    public NBTTagCompound tagCompound;

    public PacketUpdateNBTItemInventoryProgrammer() {
    }

    public PacketUpdateNBTItemInventoryProgrammer(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketUpdateNBTItemInventoryProgrammer(BlockPos pos, int slotIndex, NBTTagCompound tagCompound) {
        this.pos = pos;
        this.slotIndex = slotIndex;
        this.tagCompound = tagCompound;
    }

    protected boolean isValidBlock(World world, BlockPos blockPos, TileEntity tileEntity) {
        return tileEntity instanceof ProgrammerTileEntity;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.slotIndex = buf.readInt();
        this.tagCompound = NetworkTools.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeInt(this.slotIndex);
        NetworkTools.writeTag((ByteBuf)buf, (NBTTagCompound)this.tagCompound);
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            World world = ctx.getSender().func_130014_f_();
            TileEntity te = world.func_175625_s(this.pos);
            if (te instanceof IInventory) {
                if (!this.isValidBlock(world, this.pos, te)) {
                    return;
                }
                IInventory inv = (IInventory)te;
                ItemStack stack = inv.func_70301_a(this.slotIndex);
                if (!stack.func_190926_b()) {
                    stack.func_77982_d(this.tagCompound);
                }
                te.func_70296_d();
            }
        });
        ctx.setPacketHandled(true);
    }
}

