/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.items.variablemodule;

import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftoolscontrol.api.parameters.Parameter;
import mcjty.rftoolscontrol.blocks.ModBlocks;
import mcjty.rftoolscontrol.blocks.processor.ProcessorTileEntity;
import mcjty.rftoolscontrol.compat.rftoolssupport.ModuleDataVariable;
import mcjty.rftoolscontrol.config.ConfigSetup;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class VariableScreenModule
implements IScreenModule<ModuleDataVariable> {
    private int dim = 0;
    private BlockPos coordinate = BlockPosTools.INVALID;
    private int varIdx = -1;

    public ModuleDataVariable getData(IScreenDataHelper h, World worldObj, long millis) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            return null;
        }
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)this.coordinate)) {
            return null;
        }
        Block block = world.func_180495_p(this.coordinate).func_177230_c();
        if (block != ModBlocks.processorBlock) {
            return null;
        }
        if (this.varIdx < 0 || this.varIdx >= 32) {
            return null;
        }
        TileEntity te = world.func_175625_s(this.coordinate);
        if (te instanceof ProcessorTileEntity) {
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            Parameter parameter = processor.getParameter(this.varIdx);
            return new ModuleDataVariable(parameter);
        }
        return null;
    }

    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.varIdx = tagCompound.func_74764_b("varIdx") ? tagCompound.func_74762_e("varIdx") : -1;
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.func_74764_b("monitorx")) {
                this.dim = tagCompound.func_74764_b("monitordim") ? tagCompound.func_74762_e("monitordim") : tagCompound.func_74762_e("dim");
                if (dim == this.dim) {
                    BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                    int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                    int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                    int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    public int getRfPerTick() {
        return ConfigSetup.VARIABLEMODULE_RFPERTICK.get();
    }

    public void mouseClick(World world, int x, int y, boolean clicked, EntityPlayer player) {
    }
}

