/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.editors;

import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.rftoolscontrol.api.parameters.Inventory;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.StringUtils;

public class InventoryEditor
extends AbstractParameterEditor {
    private TextField nameLabel;
    private ChoiceLabel sideLabel;
    private ChoiceLabel intSideLabel;

    private static Inventory parseInventorySafe(String name, String sideS, String intSideS) {
        if ("*".equals(sideS)) {
            return null;
        }
        EnumFacing side = EnumFacing.func_176739_a((String)StringUtils.lowerCase((String)sideS));
        EnumFacing intSide = "*".equals(intSideS) ? null : EnumFacing.func_176739_a((String)StringUtils.lowerCase((String)intSideS));
        return new Inventory(name, side, intSide);
    }

    @Override
    public void initialFocusInternal(Window window) {
        window.setTextFocus((Widget)this.nameLabel);
    }

    @Override
    public int getHeight() {
        return 50;
    }

    @Override
    public void build(Minecraft mc, Gui gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = new Panel(mc, gui).setLayout((Layout)new VerticalLayout());
        this.nameLabel = (TextField)((TextField)new TextField(mc, gui).addTextEvent((o, text) -> callback.valueChanged(this.readValue())).addTextEnterEvent((parent, newText) -> this.closeWindow()).setDesiredWidth(50)).setDesiredHeight(14);
        constantPanel.addChild((Widget)this.createLabeledPanel(mc, gui, "Node name:", (Widget<?>)this.nameLabel, "Optional name of a node in the network"));
        this.sideLabel = (ChoiceLabel)new ChoiceLabel(mc, gui).addChoices(new String[]{"*", "Down", "Up", "North", "South", "West", "East"}).addChoiceEvent((parent, newChoice) -> callback.valueChanged(this.readValue())).setDesiredWidth(60);
        constantPanel.addChild((Widget)this.createLabeledPanel(mc, gui, "Side:", (Widget<?>)this.sideLabel, "Side relative to processor or node", "for the desired inventory"));
        this.intSideLabel = (ChoiceLabel)new ChoiceLabel(mc, gui).addChoices(new String[]{"*", "Down", "Up", "North", "South", "West", "East"}).addChoiceEvent((parent, newChoice) -> callback.valueChanged(this.readValue())).setDesiredWidth(60);
        constantPanel.addChild((Widget)this.createLabeledPanel(mc, gui, "Access:", (Widget<?>)this.intSideLabel, "Optional side from which we want to", "access the given inventory"));
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_INVENTORY);
    }

    @Override
    protected ParameterValue readConstantValue() {
        return ParameterValue.constant(InventoryEditor.parseInventorySafe(this.nameLabel.getText(), this.sideLabel.getCurrentChoice(), this.intSideLabel.getCurrentChoice()));
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.sideLabel.setChoice("*");
        } else {
            Inventory inv = (Inventory)value.getValue();
            this.nameLabel.setText(inv.getNodeName() == null ? "" : inv.getNodeName());
            this.sideLabel.setChoice(StringUtils.capitalize((String)inv.getSide().toString()));
            if (inv.getIntSide() == null) {
                this.intSideLabel.setChoice("*");
            } else {
                this.intSideLabel.setChoice(StringUtils.capitalize((String)inv.getIntSide().toString()));
            }
        }
    }
}

