/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.handler;

import elec332.core.api.annotations.StaticLoad;
import elec332.core.api.info.IInfoProvider;
import elec332.core.api.info.IInfoProviderEntity;
import elec332.core.api.registry.ISingleObjectRegistry;
import elec332.core.api.registry.ISingleRegister;
import elec332.core.api.registry.SimpleRegistries;
import elec332.core.api.world.IAdvancedChunkPopulator;
import elec332.core.api.world.IFeatureGenerator;
import elec332.core.api.world.IWorldGenHook;
import elec332.core.grid.IStructureWorldEventHandler;
import elec332.core.handler.ElecCoreSetup;
import elec332.core.util.FMLUtil;
import java.util.function.Predicate;

@StaticLoad
public final class ElecCoreRegistrar {
    public static final ISingleObjectRegistry<IStructureWorldEventHandler> GRIDHANDLERS;
    public static final ISingleObjectRegistry<IInfoProvider> INFORMATION_PROVIDERS;
    public static final ISingleObjectRegistry<IInfoProviderEntity> INFORMATION_PROVIDERS_ENTITY;
    public static final ISingleObjectRegistry<IWorldGenHook> WORLD_GEN_HOOKS;
    public static final ISingleRegister<IAdvancedChunkPopulator> WORLD_POPULATORS;
    public static final ISingleRegister<IFeatureGenerator> WORLD_FEATURE_GENERATORS;
    private static final Predicate IN_MOD_LOADING;

    private ElecCoreRegistrar() {
        throw new IllegalAccessError();
    }

    static {
        IN_MOD_LOADING = input -> FMLUtil.isInModInitialisation();
        GRIDHANDLERS = SimpleRegistries.newSingleObjectRegistry(IN_MOD_LOADING);
        INFORMATION_PROVIDERS = SimpleRegistries.newSingleObjectRegistry(IN_MOD_LOADING);
        INFORMATION_PROVIDERS_ENTITY = SimpleRegistries.newSingleObjectRegistry(IN_MOD_LOADING);
        WORLD_GEN_HOOKS = (ISingleObjectRegistry)((Object)ElecCoreSetup.worldGenManager);
        WORLD_POPULATORS = chunkPopulator -> ElecCoreSetup.worldGenManager.register((IAdvancedChunkPopulator)chunkPopulator);
        WORLD_FEATURE_GENERATORS = generator -> ElecCoreSetup.worldGenManager.register((IFeatureGenerator)generator);
    }
}

