/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractCreativeTab
extends CreativeTabs {
    @SideOnly(value=Side.CLIENT)
    private ItemStack clientStack;
    private final Supplier<ItemStack> icon;

    public static AbstractCreativeTab create(String label, ItemStack icon) {
        return AbstractCreativeTab.create(AbstractCreativeTab.getNextID(), label, icon);
    }

    public static AbstractCreativeTab create(String label, Supplier<ItemStack> icon) {
        return AbstractCreativeTab.create(AbstractCreativeTab.getNextID(), label, icon);
    }

    @Nonnull
    public static AbstractCreativeTab create(int index, String label, ItemStack icon) {
        return AbstractCreativeTab.create(index, label, () -> icon);
    }

    @Nonnull
    public static AbstractCreativeTab create(int index, String label, Supplier<ItemStack> icon) {
        return (AbstractCreativeTab)AbstractCreativeTab.createTab(index, label, icon);
    }

    @Nonnull
    private static CreativeTabs createTab(int index, String label, Supplier<ItemStack> icon) {
        return new AbstractCreativeTab(index, label, (Supplier)icon){};
    }

    public AbstractCreativeTab(String label, Supplier<ItemStack> icon) {
        this(AbstractCreativeTab.getNextID(), label, icon);
    }

    public AbstractCreativeTab(int index, String label, Supplier<ItemStack> icon) {
        super(index, label);
        this.icon = icon;
        this.initStack();
    }

    private void initStack() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.clientStack = this.icon.get();
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ItemStack func_78016_d() {
        return this.clientStack;
    }
}

