/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import elec332.core.util.EntityHelper;
import elec332.core.util.RayTraceHelper;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class PlayerHelper {
    public static double getBlockReachDistance(EntityPlayer player) {
        return player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
    }

    public static Vec3d getCorrectedHeadVec(EntityPlayer player) {
        double yCoord = player.field_70163_u;
        if (player.func_130014_f_().field_72995_K) {
            yCoord += (double)(player.func_70047_e() - player.getDefaultEyeHeight());
        } else {
            yCoord += (double)player.func_70047_e();
            if (player instanceof EntityPlayerMP && player.func_70093_af()) {
                yCoord -= 0.08;
            }
        }
        return new Vec3d(player.field_70165_t, yCoord, player.field_70161_v);
    }

    public static UUID getPlayerUUID(EntityPlayer player) {
        return player.func_146103_bH().getId();
    }

    public static void sendMessageToPlayer(@Nonnull ICommandSender player, String s) {
        PlayerHelper.sendMessageToPlayer(player, (ITextComponent)new TextComponentString(s));
    }

    public static void sendMessageToPlayer(@Nonnull ICommandSender player, ITextComponent s) {
        player.func_145747_a(s);
    }

    public static void activateFlight(EntityPlayer player) {
        player.field_71075_bZ.field_75101_c = true;
        player.func_71016_p();
    }

    public static void deactivateFlight(EntityPlayer player) {
        player.field_71075_bZ.field_75101_c = false;
        if (player.field_71075_bZ.field_75100_b) {
            player.field_71075_bZ.field_75100_b = false;
        }
        player.func_71016_p();
    }

    public static void smiteEntity(EntityPlayer attacker, EntityLivingBase target) {
        EntityHelper.smiteEntity(DamageSource.func_76365_a((EntityPlayer)attacker), target);
    }

    public static boolean isPlayerInCreative(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d;
    }

    public static RayTraceResult getPosPlayerIsLookingAt(EntityPlayer player, double range) {
        return RayTraceHelper.rayTrace((EntityLivingBase)player, range);
    }

    public static boolean arePlayersEqual(EntityPlayer player1, EntityPlayer player2) {
        return player1.func_110124_au() == player2.func_110124_au();
    }
}

