/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world.feature;

import elec332.core.api.config.IConfigurableElement;
import elec332.core.api.world.IFeatureGenerator;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.config.Configuration;

public class FeatureWorldGenerator
implements IFeatureGenerator,
IConfigurableElement {
    protected final String name;
    protected int times;
    protected WorldGenerator worldGenerator;
    protected int maxY;
    protected boolean generate;
    protected float multiplier;

    public static FeatureWorldGenerator wrap(String name, WorldGenerator worldGenerator) {
        return new FeatureWorldGenerator(name, 1, worldGenerator);
    }

    public FeatureWorldGenerator(String name, int times, WorldGenerator worldGenerator) {
        this.worldGenerator = worldGenerator;
        this.name = name;
        this.maxY = 64;
        this.times = times;
        this.multiplier = 1.0f;
        this.generate = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getConfigCategoryName() {
        return this.getName();
    }

    @Override
    public boolean generateFeature(Random random, int chunkX, int chunkZ, World world) {
        boolean ret = false;
        if (this.generate) {
            BlockPos pos = new BlockPos(chunkX * 16 + random.nextInt(16), random.nextInt(this.maxY), chunkZ * 16 + random.nextInt(16));
            if (this.times <= 1) {
                if (random.nextFloat() < this.multiplier) {
                    ret = this.worldGenerator.func_180709_b(world, random, pos);
                }
            } else {
                int i = 0;
                while ((float)i < (float)this.times * this.multiplier) {
                    ret |= this.worldGenerator.func_180709_b(world, random, pos);
                    ++i;
                }
            }
        }
        return ret;
    }

    public FeatureWorldGenerator setTimes(int times) {
        this.times = times;
        return this;
    }

    public FeatureWorldGenerator setMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public FeatureWorldGenerator setGenerationMultiplier(float multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    public FeatureWorldGenerator setShouldGen(boolean shouldGen) {
        this.generate = shouldGen;
        return this;
    }

    @Override
    public void reconfigure(Configuration config) {
        this.generate = config.getBoolean("shouldGenerate", this.getConfigCategoryName(), this.generate, "Value which determines whether the feature should generate in the world or not");
        String s = this.times <= 1 ? "Sets the chance this feature will generate in a chunk." : "Sets how many times the mod will attempt to generate ores per chunk. 1 is normal, 0 is not, 2 is 200%, ect.";
        this.multiplier = config.getFloat("generationMultiplier", this.getConfigCategoryName(), this.multiplier, 0.0f, 1000.0f, s);
    }
}

