/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world.schematic;

import com.google.common.collect.Maps;
import elec332.core.ElecCore;
import elec332.core.api.structure.ISchematic;
import elec332.core.api.util.Area;
import elec332.core.util.IOHelper;
import elec332.core.util.NBTTypes;
import elec332.core.util.RegistryHelper;
import elec332.core.world.WorldHelper;
import elec332.core.world.schematic.Schematic;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum SchematicHelper {
    INSTANCE;


    public Schematic loadSchematic(File file) {
        try {
            return this.loadSchematic(new FileInputStream(file));
        }
        catch (IOException e) {
            ElecCore.logger.fatal("Error loading schematic at: " + file);
            ElecCore.logger.fatal((Object)e);
            return null;
        }
    }

    public Schematic loadSchematic(ResourceLocation rl) {
        try {
            return this.loadSchematic(IOHelper.getFromResource(rl));
        }
        catch (IOException e) {
            ElecCore.logger.fatal("Error loading schematic at: " + rl);
            ElecCore.logger.fatal((Object)e);
            return null;
        }
    }

    public Schematic loadSchematic(InputStream is) {
        try {
            NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)is);
            is.close();
            return this.loadModSchematic(tag);
        }
        catch (Exception e) {
            ElecCore.logger.fatal("Error loading schematic.");
            ElecCore.logger.fatal((Object)e);
            return null;
        }
    }

    public Schematic loadModSchematic(NBTTagCompound nbt) {
        try {
            int i;
            NBTTagList tileEntities = nbt.func_150295_c("TileEntities", (int)NBTTypes.COMPOUND.getID());
            short width = nbt.func_74765_d("Width");
            short height = nbt.func_74765_d("Height");
            short length = nbt.func_74765_d("Length");
            short horizon = nbt.func_74765_d("Horizon");
            NBTTagList blockData = nbt.func_150295_c("BlockData", (int)NBTTypes.COMPOUND.getID());
            byte[] metadata = nbt.func_74770_j("Data");
            int[] blockArray = nbt.func_74759_k("Blocks");
            Block[] blocks = new Block[width * height * length];
            HashMap idMap = Maps.newHashMap();
            idMap.put(-1, Blocks.field_150350_a);
            for (i = 0; i < blockData.func_74745_c(); ++i) {
                NBTTagCompound tag = blockData.func_150305_b(i);
                idMap.put(tag.func_74762_e("p"), RegistryHelper.getBlockRegistry().getValue(new ResourceLocation(tag.func_74779_i("m"), tag.func_74779_i("b"))));
            }
            for (i = 0; i < blockArray.length; ++i) {
                blocks[i] = (Block)idMap.get(blockArray[i]);
            }
            return new Schematic(tileEntities, width, height, length, horizon, metadata, blocks);
        }
        catch (Exception ex) {
            ElecCore.logger.fatal("Error loading ModSchematic.");
            ElecCore.logger.fatal((Object)ex);
            return null;
        }
    }

    public NBTTagCompound writeSchematic(ISchematic schematic_) {
        Schematic schematic = this.wrap(schematic_);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("Width", schematic.getBlockWidth());
        nbt.func_74777_a("Height", schematic.getBlockHeight());
        nbt.func_74777_a("Length", schematic.getBlockLength());
        nbt.func_74777_a("Horizon", schematic.getHorizon());
        nbt.func_74773_a("Data", schematic.data);
        nbt.func_74782_a("TileEntities", (NBTBase)schematic.tileDataList);
        int[] blocks = new int[schematic.blocks.length];
        NBTTagList blockData = new NBTTagList();
        HashMap map = Maps.newHashMap();
        int id = 0;
        for (int i = 0; i < schematic.blocks.length; ++i) {
            Block block = schematic.blocks[i];
            if (block != Blocks.field_150350_a) {
                if (!map.containsKey(block)) {
                    ResourceLocation rl = RegistryHelper.getBlockRegistry().getKey((IForgeRegistryEntry)block);
                    if (rl == null) {
                        blocks[i] = -1;
                        continue;
                    }
                    NBTTagCompound tag = new NBTTagCompound();
                    int ID = id++;
                    tag.func_74768_a("p", ID);
                    map.put(block, ID);
                    tag.func_74778_a("m", rl.func_110624_b());
                    tag.func_74778_a("b", rl.func_110623_a());
                    blockData.func_74742_a((NBTBase)tag);
                }
                blocks[i] = (Integer)map.get(block);
                continue;
            }
            blocks[i] = -1;
        }
        nbt.func_74783_a("Blocks", blocks);
        nbt.func_74782_a("BlockData", (NBTBase)blockData);
        return nbt;
    }

    public Schematic createModSchematic(IBlockAccess world, Area area, short horizon) {
        if (world == null || area == null) {
            return null;
        }
        Block[] blocks = new Block[area.getBlockCount()];
        byte[] data = new byte[area.getBlockCount()];
        NBTTagList tileList = new NBTTagList();
        int i = 0;
        int schematicY = 0;
        for (int y = area.minY; y <= area.maxY; ++y) {
            int schematicZ = 0;
            for (int z = area.minZ; z <= area.maxZ; ++z) {
                int schematicX = 0;
                for (int x = area.minX; x <= area.maxX; ++x) {
                    BlockPos pos = new BlockPos(x, y, z);
                    blocks[i] = WorldHelper.getBlockAt(world, pos);
                    data[i] = (byte)WorldHelper.getBlockMeta(world, pos);
                    TileEntity tile = WorldHelper.getTileAt(world, pos);
                    if (tile != null) {
                        NBTTagCompound tileNBT = new NBTTagCompound();
                        tile.func_189515_b(tileNBT);
                        tileNBT.func_74768_a("x", schematicX);
                        tileNBT.func_74768_a("y", schematicY);
                        tileNBT.func_74768_a("z", schematicZ);
                        tileList.func_74742_a((NBTBase)tileNBT);
                    }
                    ++i;
                    ++schematicX;
                }
                ++schematicZ;
            }
            ++schematicY;
        }
        return new Schematic(tileList, area.getBlockWidth(), area.getBlockHeight(), area.getBlockHeight(), horizon, data, blocks);
    }

    public Schematic wrap(final ISchematic schematic) {
        if (schematic instanceof Schematic) {
            return (Schematic)schematic;
        }
        return this.createModSchematic(new IBlockAccess(){

            @Nullable
            public TileEntity func_175625_s(BlockPos pos) {
                NBTTagCompound tag = schematic.getTileData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                if (tag != null) {
                    TileEntity.func_190200_a(null, (NBTTagCompound)tag);
                }
                return null;
            }

            public int func_175626_b(BlockPos pos, int lightValue) {
                throw new UnsupportedOperationException();
            }

            public IBlockState func_180495_p(BlockPos pos) {
                return schematic.getBlockState(pos);
            }

            public boolean func_175623_d(BlockPos pos) {
                throw new UnsupportedOperationException();
            }

            public Biome func_180494_b(BlockPos pos) {
                throw new UnsupportedOperationException();
            }

            public int func_175627_a(BlockPos pos, EnumFacing direction) {
                throw new UnsupportedOperationException();
            }

            public WorldType func_175624_G() {
                throw new UnsupportedOperationException();
            }

            public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
                throw new UnsupportedOperationException();
            }
        }, new Area(0, 0, 0, schematic.getBlockWidth() - 1, schematic.getBlockHeight() - 1, schematic.getBlockLength() - 1), schematic.getHorizon());
    }
}

