/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.gui.tinker.clickable;

import java.util.List;
import net.machinemuse.numina.client.gui.clickable.Clickable;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.math.Colour;
import net.machinemuse.numina.math.geometry.DrawableMuseRect;
import net.machinemuse.numina.math.geometry.MusePoint2D;

public class ClickableButton
extends Clickable {
    protected String label;
    protected MusePoint2D radius;
    protected DrawableMuseRect rect;
    protected boolean enabled;
    protected boolean visible = true;

    public ClickableButton(String label, MusePoint2D position, boolean enabled) {
        this.label = label;
        this.position = position;
        this.radius = new MusePoint2D(MuseRenderer.getStringWidth((String)label) / 2.0 + 2.0, 6.0);
        this.rect = new DrawableMuseRect(position.getX() - this.radius.getX(), position.getY() - this.radius.getY(), position.getX() + this.radius.getX(), position.getY() + this.radius.getY(), new Colour(0.5, (double)0.6f, (double)0.8f, 1.0), new Colour((double)0.3f, (double)0.3f, (double)0.3f, 1.0));
        this.setEnabled(enabled);
    }

    public void draw() {
        if (this.visible) {
            Colour bottomcolour;
            Colour topcolour;
            if (this.isEnabled()) {
                topcolour = new Colour(0.5, (double)0.6f, (double)0.8f, 1.0);
                bottomcolour = new Colour((double)0.3f, (double)0.3f, (double)0.3f, 1.0);
            } else {
                topcolour = new Colour((double)0.8f, (double)0.3f, (double)0.3f, 1.0);
                bottomcolour = new Colour((double)0.8f, (double)0.6f, (double)0.6f, 1.0);
            }
            this.rect.setLeft(this.position.getX() - this.radius.getX());
            this.rect.setTop(this.position.getY() - this.radius.getY());
            this.rect.setRight(this.position.getX() + this.radius.getX());
            this.rect.setBottom(this.position.getY() + this.radius.getY());
            this.rect.setOutsideColour(topcolour);
            this.rect.setInsideColour(bottomcolour);
            this.rect.draw();
            MuseRenderer.drawCenteredString((String)this.label, (double)this.position.getX(), (double)(this.position.getY() - 4.0));
        }
    }

    public boolean hitBox(double x, double y) {
        boolean hitx = Math.abs(this.position.getX() - x) < this.radius.getX();
        boolean hity = Math.abs(this.position.getY() - y) < this.radius.getY();
        return hitx && hity;
    }

    public List<String> getToolTip() {
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ClickableButton setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void enable() {
        this.enabled = true;
    }

    public void buttonOn() {
        this.enable();
        this.show();
    }

    public void buttonOff() {
        this.disable();
        this.hide();
    }

    public void disable() {
        this.enabled = false;
    }

    public void show() {
        this.visible = true;
    }

    public void hide() {
        this.visible = false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public ClickableButton setLable(String label) {
        this.label = label;
        return this;
    }

    public String getLabel() {
        return this.label;
    }
}

