/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.gui.tinker.clickable;

import java.util.ArrayList;
import java.util.List;
import net.machinemuse.numina.client.gui.clickable.Clickable;
import net.machinemuse.numina.client.render.MuseIconUtils;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.client.render.MuseTextureUtils;
import net.machinemuse.numina.math.Colour;
import net.machinemuse.numina.math.geometry.MusePoint2D;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.numina.string.MuseStringUtils;
import net.machinemuse.powersuits.gui.GuiIcons;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;

public class ClickableModule
extends Clickable {
    final Colour checkmarkcolour = new Colour(0.0, (double)0.667f, 0.0, 1.0);
    boolean allowed = true;
    boolean installed = false;
    IPowerModule module;

    public ClickableModule(IPowerModule module, MusePoint2D position) {
        super(position);
        this.module = module;
    }

    public List<String> getToolTip() {
        ArrayList<String> toolTipText = new ArrayList<String>();
        toolTipText.add(this.getLocalizedName(this.getModule()));
        toolTipText.addAll(MuseStringUtils.wrapStringToLength((String)this.getLocalizedDescription(this.getModule()), (int)30));
        return toolTipText;
    }

    public String getLocalizedName(IPowerModule m) {
        if (m == null) {
            return "";
        }
        return m.getDataName() != null && !m.getDataName().isEmpty() ? I18n.func_135052_a((String)(m.getUnlocalizedName() + ".name"), (Object[])new Object[0]) : "broken translation for module name";
    }

    public String getLocalizedDescription(IPowerModule m) {
        if (m == null) {
            return "";
        }
        return m.getDataName() != null && !m.getDataName().isEmpty() ? I18n.func_135052_a((String)(m.getUnlocalizedName() + ".desc"), (Object[])new Object[0]) : "broken translation for module description";
    }

    public void draw() {
        double k = 2.147483647E9;
        double left = this.getPosition().getX() - 8.0;
        double top = this.getPosition().getY() - 8.0;
        this.drawPartial(left, top, left + 16.0, top + 16.0);
    }

    public void drawPartial(double xmino, double ymino, double xmaxo, double ymaxo) {
        double left = this.getPosition().getX() - 8.0;
        double top = this.getPosition().getY() - 8.0;
        MuseTextureUtils.pushTexture((String)"textures/atlas/blocks.png");
        MuseIconUtils.drawIconAt((double)left, (double)top, (TextureAtlasSprite)this.getModule().getIcon(null), (Colour)Colour.WHITE);
        MuseTextureUtils.popTexture();
        if (!this.allowed) {
            String string = MuseStringUtils.wrapFormatTags((String)"x", (MuseStringUtils.FormatCodes)MuseStringUtils.FormatCodes.DarkRed);
            MuseRenderer.drawString((String)string, (double)(this.getPosition().getX() + 3.0), (double)(this.getPosition().getY() + 1.0));
        } else if (this.installed) {
            new GuiIcons.Checkmark(this.getPosition().getX() - 8.0 + 1.0, this.getPosition().getY() - 8.0 + 1.0, this.checkmarkcolour, null, null, null, null);
        }
    }

    public boolean hitBox(double x, double y) {
        boolean hitx = Math.abs(x - this.getPosition().getX()) < 8.0;
        boolean hity = Math.abs(y - this.getPosition().getY()) < 8.0;
        return hitx && hity;
    }

    public IPowerModule getModule() {
        return this.module;
    }

    public boolean equals(ClickableModule other) {
        return this.module == other.getModule();
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }
}

