/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.gui.tinker.frame;

import java.util.List;
import net.machinemuse.numina.client.gui.scrollable.ScrollableFrame;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.item.MuseItemUtils;
import net.machinemuse.numina.math.Colour;
import net.machinemuse.numina.math.geometry.MusePoint2D;
import net.machinemuse.numina.string.MuseStringUtils;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.gui.tinker.frame.ItemSelectionFrame;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class DetailedSummaryFrame
extends ScrollableFrame {
    public static final double SCALEFACTOR = 1.0;
    protected EntityPlayer player;
    protected int slotPoints;
    protected int energy;
    protected double armor;
    protected ItemSelectionFrame itemSelectionFrame;

    public DetailedSummaryFrame(EntityPlayer player, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, ItemSelectionFrame itemSelectionFrame) {
        super(topleft.times(1.0), bottomright.times(1.0), borderColour, insideColour);
        this.player = player;
        this.itemSelectionFrame = itemSelectionFrame;
    }

    public void update(double mousex, double mousey) {
        this.energy = 0;
        this.armor = 0.0;
        this.slotPoints = 0;
        if (this.itemSelectionFrame.getSelectedItem() != null) {
            this.slotPoints += (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(this.itemSelectionFrame.getSelectedItem().getItem(), "slotPoints");
        }
        for (ItemStack stack : MuseItemUtils.getModularItemsEquipped((EntityPlayer)this.player)) {
            this.energy += (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(stack, "maxEnergy");
            this.armor += ModuleManager.INSTANCE.getOrSetModularPropertyDouble(stack, "armorPhysical");
            this.armor += ModuleManager.INSTANCE.getOrSetModularPropertyDouble(stack, "armorEnergy");
        }
    }

    public void draw() {
        if (this.player != null) {
            int i;
            GL11.glPushMatrix();
            GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
            super.draw();
            int margin = 4;
            int nexty = (int)this.border.top() + margin;
            MuseRenderer.drawCenteredString((String)I18n.func_135052_a((String)"gui.powersuits.equippedTotals", (Object[])new Object[0]), (double)((this.border.left() + this.border.right()) / 2.0), (double)nexty);
            nexty += 10;
            String formattedValue = MuseStringUtils.formatNumberFromUnits((double)this.energy, (String)PowerModuleBase.getUnit("maxEnergy"));
            String name = I18n.func_135052_a((String)"gui.powersuits.energyStorage", (Object[])new Object[0]);
            double valueWidth = MuseRenderer.getStringWidth((String)formattedValue);
            double allowedNameWidth = this.border.width() - valueWidth - (double)(margin * 2);
            List namesList = MuseStringUtils.wrapStringToVisualLength((String)name, (double)allowedNameWidth);
            for (i = 0; i < namesList.size(); ++i) {
                MuseRenderer.drawString((String)((String)namesList.get(i)), (double)(this.border.left() + (double)margin), (double)(nexty + 9 * i));
            }
            MuseRenderer.drawRightAlignedString((String)formattedValue, (double)(this.border.right() - (double)margin), (double)(nexty + 9 * (namesList.size() - 1) / 2));
            nexty += 10 * namesList.size() + 1;
            if (this.slotPoints > 0) {
                formattedValue = MuseStringUtils.wrapFormatTags((String)MuseStringUtils.formatNumberFromUnits((double)this.slotPoints, (String)"pts"), (MuseStringUtils.FormatCodes)MuseStringUtils.FormatCodes.BrightGreen);
                name = I18n.func_135052_a((String)"gui.powersuits.slotpoints", (Object[])new Object[0]);
                valueWidth = MuseRenderer.getStringWidth((String)formattedValue);
                allowedNameWidth = this.border.width() - valueWidth - (double)(margin * 2);
                namesList = MuseStringUtils.wrapStringToVisualLength((String)name, (double)allowedNameWidth);
                assert (namesList != null);
                for (i = 0; i < namesList.size(); ++i) {
                    MuseRenderer.drawString((String)((String)namesList.get(i)), (double)(this.border.left() + (double)margin), (double)(nexty + 9 * i));
                }
                MuseRenderer.drawRightAlignedString((String)formattedValue, (double)(this.border.right() - (double)margin), (double)(nexty + 9 * (namesList.size() - 1) / 2));
                nexty += 10 * namesList.size() + 1;
            }
            formattedValue = MuseStringUtils.formatNumberFromUnits((double)this.armor, (String)"pts");
            name = I18n.func_135052_a((String)"gui.powersuits.armor", (Object[])new Object[0]);
            valueWidth = MuseRenderer.getStringWidth((String)formattedValue);
            allowedNameWidth = this.border.width() - valueWidth - (double)(margin * 2);
            namesList = MuseStringUtils.wrapStringToVisualLength((String)name, (double)allowedNameWidth);
            assert (namesList != null);
            for (i = 0; i < namesList.size(); ++i) {
                MuseRenderer.drawString((String)((String)namesList.get(i)), (double)(this.border.left() + (double)margin), (double)(nexty + 9 * i));
            }
            MuseRenderer.drawRightAlignedString((String)formattedValue, (double)(this.border.right() - (double)margin), (double)(nexty + 9 * (namesList.size() - 1) / 2));
            GL11.glPopMatrix();
        }
    }

    public void onMouseDown(double x, double y, int button) {
    }

    public void onMouseUp(double x, double y, int button) {
    }

    public List<String> getToolTip(int x, int y) {
        return null;
    }
}

