/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.api.upgrades;

import com.google.common.collect.Multimap;
import crazypants.enderio.api.ILocalizable;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IRule;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public interface IDarkSteelUpgrade
extends IForgeRegistryEntry<IDarkSteelUpgrade>,
ILocalizable {
    @Override
    @Nonnull
    public String getUnlocalizedName();

    @Nonnull
    default public String getDisplayName() {
        return I18n.func_74838_a((String)(this.getUnlocalizedName() + ".name"));
    }

    @Nonnull
    default public Pair<String, Integer> getSortKey() {
        return Pair.of((Object)this.getUnlocalizedName(), (Object)0);
    }

    public int getLevelCost();

    default public boolean hasUpgrade(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof IDarkSteelItem ? this.hasUpgrade(stack, (IDarkSteelItem)stack.func_77973_b()) : false;
    }

    public boolean hasUpgrade(@Nonnull ItemStack var1, @Nonnull IDarkSteelItem var2);

    default public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return !this.hasUpgrade(stack, item) && this.getRules().stream().allMatch(rule -> rule.check(stack, item).passes());
    }

    default public boolean canOtherBeRemoved(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull IDarkSteelUpgrade other) {
        return true;
    }

    public void addToItem(@Nonnull ItemStack var1, @Nonnull IDarkSteelItem var2);

    public void removeFromItem(@Nonnull ItemStack var1, @Nonnull IDarkSteelItem var2);

    default public void onPlayerTick(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull EntityPlayer player) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void doMultiplayerSFX(@Nonnull EntityPlayer otherPlayer) {
    }

    default public void addAttributeModifiers(@Nonnull EntityEquipmentSlot slot, @Nonnull ItemStack stack, @Nonnull Multimap<String, AttributeModifier> map) {
    }

    @Nonnull
    public List<IRule> getRules();
}

