/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.fluid;

import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.network.NetworkUtil;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.filter.fluid.IFluidFilter;
import crazypants.enderio.base.integration.jei.IHaveGhostTargets;
import crazypants.enderio.util.NbtValue;
import crazypants.enderio.util.Prep;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;

public class FluidFilter
implements IFluidFilter {
    private final FluidStack[] fluids = new FluidStack[5];
    private boolean isBlacklist;

    @Override
    public boolean isEmpty() {
        for (FluidStack f : this.fluids) {
            if (f == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.fluids.length;
    }

    @Override
    public FluidStack getFluidStackAt(int index) {
        return this.fluids[index];
    }

    @Deprecated
    public boolean setFluid(int index, Fluid fluid) {
        this.fluids[index] = new FluidStack(fluid, 0);
        return true;
    }

    @Override
    public boolean setFluid(int index, @Nullable FluidStack fluid) {
        this.fluids[index] = fluid == null || fluid.getFluid() == null ? null : fluid;
        return true;
    }

    @Override
    public boolean setFluid(int index, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return this.setFluid(index, (FluidStack)null);
        }
        FluidStack f = FluidUtil.getFluidTypeFromItem((ItemStack)stack);
        if (f == null || f.getFluid() == null) {
            return this.setFluid(index, (FluidStack)null);
        }
        return this.setFluid(index, f);
    }

    @Override
    public boolean removeFluid(int index) {
        if (index < 0 || index >= this.fluids.length) {
            return false;
        }
        this.fluids[index] = null;
        return true;
    }

    @Deprecated
    protected void setFluid(int index, String fluidName) {
        Fluid f = FluidRegistry.getFluid((String)fluidName);
        this.setFluid(index, f);
    }

    @Override
    public boolean isBlacklist() {
        return this.isBlacklist;
    }

    @Override
    public void setBlacklist(boolean isBlacklist) {
        this.isBlacklist = isBlacklist;
    }

    @Override
    public boolean isDefault() {
        return !this.isBlacklist && this.isEmpty();
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        NbtValue.FILTER_BLACKLIST.setBoolean(nbtRoot, this.isBlacklist);
        NBTTagList fluidList = new NBTTagList();
        int index = 0;
        for (FluidStack f : this.fluids) {
            NBTTagCompound fRoot = new NBTTagCompound();
            if (f != null) {
                fRoot.func_74768_a("index", index);
                f.writeToNBT(fRoot);
                fluidList.func_74742_a((NBTBase)fRoot);
            }
            ++index;
        }
        nbtRoot.func_74782_a("fluids", (NBTBase)fluidList);
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        this.isBlacklist = NbtValue.FILTER_BLACKLIST.getBoolean(nbtRoot);
        this.clear();
        NBTTagList tagList = nbtRoot.func_150295_c("fluids", (int)nbtRoot.func_74732_a());
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            this.fluids[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagList.func_150305_b(i));
        }
    }

    private void clear() {
        for (int i = 0; i < this.fluids.length; ++i) {
            this.fluids[i] = null;
        }
    }

    @Override
    public boolean matchesFilter(FluidStack drained) {
        if (drained == null || drained.getFluid() == null) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        for (FluidStack f : this.fluids) {
            if (f == null || !f.isFluidEqual(drained)) continue;
            return !this.isBlacklist;
        }
        return this.isBlacklist;
    }

    @Override
    public void setInventorySlotContents(int slot, @Nonnull ItemStack stack) {
        this.setFluid(slot, stack);
    }

    @Override
    public void writeToByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound root = new NBTTagCompound();
        this.writeToNBT(root);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)root, (ByteBuf)buf);
    }

    @Override
    public void readFromByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound tag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.readFromNBT(tag);
    }

    public void createGhostSlots(@Nonnull NNList<GhostSlot> slots, int xOffset, int yOffset, @Nullable Runnable cb) {
        int topY = yOffset;
        int leftX = xOffset;
        int index = 0;
        int numRows = 1;
        int rowSpacing = 2;
        int numCols = 5;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                int x = leftX + col * 18;
                int y = topY + row * 18 + rowSpacing * row;
                slots.add((Object)new FluidFilterGhostSlot(index, x, y, cb));
                ++index;
            }
        }
    }

    @Override
    public int getSlotCount() {
        return this.fluids.length;
    }

    class FluidFilterGhostSlot
    extends GhostSlot
    implements IHaveGhostTargets.IFluidGhostSlot {
        private final Runnable cb;

        FluidFilterGhostSlot(int slot, int x, int y, Runnable cb) {
            this.setX(x);
            this.setY(y);
            this.setSlot(slot);
            this.cb = cb;
        }

        public void putStack(@Nonnull ItemStack stack, int realsize) {
            FluidFilter.this.setFluid(this.getSlot(), stack);
            this.cb.run();
        }

        @Nonnull
        public ItemStack getStack() {
            return ItemStack.field_190927_a;
        }

        @Override
        public void putFluidStack(@Nonnull FluidStack fluid) {
            FluidFilter.this.setFluid(this.getSlot(), fluid);
            this.cb.run();
        }

        @Override
        public void putFluid(@Nonnull Fluid fluid) {
            FluidFilter.this.setFluid(this.getSlot(), fluid);
            this.cb.run();
        }

        public boolean drawGhostSlotToolTip(@Nonnull GuiContainerBase gui, int mouseX, int mouseY) {
            FluidStack stack = FluidFilter.this.getFluidStackAt(this.getSlot());
            if (stack != null && gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                GuiUtils.drawHoveringText((ItemStack)Prep.getEmpty(), Collections.singletonList(EnumRarity.COMMON.field_77937_e + stack.getLocalizedName()), (int)mouseX, (int)mouseY, (int)gui.field_146294_l, (int)gui.field_146295_m, (int)-1, (FontRenderer)gui.getFontRenderer());
                return true;
            }
            return false;
        }
    }
}

