/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.speed;

import com.enderio.core.common.util.NNList;
import com.google.common.collect.Multimap;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IRule;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.handler.darksteel.DarkSteelController;
import crazypants.enderio.base.handler.darksteel.Rules;
import crazypants.enderio.base.item.darksteel.attributes.DarkSteelAttributeModifiers;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import info.loenwind.autoconfig.factory.IValue;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public class SpeedUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "speedBoost";
    private static final String[] numbers = new String[]{"one", "two", "three"};
    @Nonnull
    public static final SpeedUpgrade SPEED_ONE = new SpeedUpgrade(1);
    @Nonnull
    public static final SpeedUpgrade SPEED_TWO = new SpeedUpgrade(2);
    @Nonnull
    public static final SpeedUpgrade SPEED_THREE = new SpeedUpgrade(3);
    private final short level;

    @SubscribeEvent
    public static void registerDarkSteelUpgrades(@Nonnull RegistryEvent.Register<IDarkSteelUpgrade> event) {
        event.getRegistry().register((IForgeRegistryEntry)SPEED_ONE);
        event.getRegistry().register((IForgeRegistryEntry)SPEED_TWO);
        event.getRegistry().register((IForgeRegistryEntry)SPEED_THREE);
    }

    public static SpeedUpgrade loadAnyFromItem(@Nonnull ItemStack stack) {
        if (SPEED_THREE.hasUpgrade(stack)) {
            return SPEED_THREE;
        }
        if (SPEED_TWO.hasUpgrade(stack)) {
            return SPEED_TWO;
        }
        if (SPEED_ONE.hasUpgrade(stack)) {
            return SPEED_ONE;
        }
        return null;
    }

    public static boolean isEquipped(@Nonnull EntityPlayer player) {
        return SpeedUpgrade.loadAnyFromItem(player.func_184582_a(EntityEquipmentSlot.LEGS)) != null;
    }

    public SpeedUpgrade(int level) {
        super(UPGRADE_NAME, level, "enderio.darksteel.upgrade.speed_" + numbers[level - 1], (IValue<Integer>)((IValue)DarkSteelConfig.speedUpgradeCost.get(level - 1)));
        this.level = (short)level;
    }

    @Override
    protected int getMinVariant() {
        return 1;
    }

    @Override
    @Nonnull
    public List<IRule> getRules() {
        return new NNList((Object[])new IRule[]{Rules.forSlot(EntityEquipmentSlot.LEGS), EnergyUpgrade.HAS_ANY, Rules.withLevels((int)this.level, null, SPEED_ONE, SPEED_TWO), Rules.itemTypeTooltip(EntityEquipmentSlot.LEGS)});
    }

    @Override
    public boolean canOtherBeRemoved(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull IDarkSteelUpgrade other) {
        return !EnergyUpgradeManager.isLowestPowerUpgrade(other);
    }

    public short getLevel() {
        return this.level;
    }

    @Override
    public void addAttributeModifiers(@Nonnull EntityEquipmentSlot slot, @Nonnull ItemStack stack, @Nonnull Multimap<String, AttributeModifier> map) {
        EnergyUpgrade.EnergyUpgradeHolder upgradeHolder;
        if (slot == EntityEquipmentSlot.LEGS && (upgradeHolder = EnergyUpgradeManager.loadFromItem(stack)) != null && upgradeHolder.getEnergy() > 0) {
            AttributeModifier modifier = DarkSteelAttributeModifiers.getWalkSpeed(this.getLevel(), upgradeHolder.getUpgrade().getLevel());
            map.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)modifier);
        }
    }

    @Override
    public void onPlayerTick(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        double horzMovement = Math.abs(player.field_70140_Q - player.field_70141_P);
        int costModifier = (Integer)(player.func_70051_ag() ? DarkSteelConfig.darkSteelSpeedSprintEnergyCost : DarkSteelConfig.darkSteelSpeedWalkEnergyCost).get();
        int cost = (int)(horzMovement * (double)costModifier);
        DarkSteelController.usePlayerEnergy(player, EntityEquipmentSlot.LEGS, cost);
    }
}

