/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.loot;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.loot.LootSelector;
import crazypants.enderio.base.loot.SetRandomDarkUpgrade;
import crazypants.enderio.base.loot.SetRandomEnergy;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.material.material.Material;
import crazypants.enderio.util.CapturedMob;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class LootManager {
    @Nonnull
    private static final String ERROR_UNREGISTERED_ITEM = "found unregistered item";
    @Nonnull
    private static final String RL_MINECRAFT = "minecraft";
    @Nonnull
    private static final LootCondition[] NO_CONDITIONS = new LootCondition[0];
    static boolean useTables = true;
    @Nonnull
    private static final Set<ResourceLocation> MC_TABLES = new HashSet<ResourceLocation>();
    static int capCount;
    @Nonnull
    private static final LootSelector ls;

    public static void init(@Nonnull EnderIOLifecycleEvent.Init.Post event) {
        if (useTables) {
            for (ResourceLocation resourceLocation : MC_TABLES) {
                LootTableList.func_186375_a((ResourceLocation)LootManager.eio(resourceLocation));
            }
        }
    }

    private static void injectTables(@Nonnull LootTableLoadEvent evt) {
        if (MC_TABLES.contains(evt.getName())) {
            LootPool lp = new LootPool(new LootEntry[0], NO_CONDITIONS, new RandomValueRange(1.0f, 3.0f), new RandomValueRange(0.0f, 0.0f), "Ender IO");
            LootManager.addTable(lp, LootManager.eio(evt.getName()));
            evt.getTable().addPool(lp);
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(@Nonnull LootTableLoadEvent evt) {
        if (useTables) {
            LootManager.injectTables(evt);
            return;
        }
        LootTable table = evt.getTable();
        LootPool lp = new LootPool(new LootEntry[0], NO_CONDITIONS, new RandomValueRange(1.0f, 3.0f), new RandomValueRange(0.0f, 0.0f), "Ender IO");
        if (evt.getName().equals((Object)LootTableList.field_186422_d)) {
            lp.addEntry(LootManager.createLootEntry(Alloy.DARK_STEEL.getStackIngot(), 1, 3, 0.25f));
            lp.addEntry(LootManager.createLootEntry(ModObject.itemConduitProbe.getItemNN(), 0.1f));
            lp.addEntry(LootManager.createLootEntry(Items.field_151128_bU, 3, 16, 0.25f));
            lp.addEntry(LootManager.createLootEntry(Items.field_151075_bm, 1, 4, 0.2f));
            lp.addEntry(LootManager.createLootEntry(Items.field_151079_bi, 1, 2, 0.3f));
            lp.addEntry(LootManager.createDarkSteelLootEntry(ModObject.itemDarkSteelSword.getItemNN(), 0.1f));
            lp.addEntry(LootManager.createDarkSteelLootEntry(ModObject.itemDarkSteelBoots.getItemNN(), 0.1f));
            lp.addEntry(LootManager.createLootEntry(Material.GEAR_WOOD.getStack(), 1, 2, 0.5f));
            lp.addEntry(LootManager.createLootCapacitor(0.15f));
            lp.addEntry(LootManager.createLootCapacitor(0.15f));
            lp.addEntry(LootManager.createLootCapacitor(0.15f));
        } else if (evt.getName().equals((Object)LootTableList.field_186424_f)) {
            lp.addEntry(LootManager.createLootEntry(Alloy.DARK_STEEL.getStackIngot(), 1, 3, 0.05f));
            lp.addEntry(LootManager.createLootEntry(Items.field_151079_bi, 1, 2, 0.1f));
            lp.addEntry(LootManager.createDarkSteelLootEntry(ModObject.itemDarkSteelSword.getItemNN(), 0.2f));
            lp.addEntry(LootManager.createLootEntry(Material.GEAR_WOOD.getStack(), 1, 2, 0.5f));
            lp.addEntry(LootManager.createLootCapacitor(0.15f));
            lp.addEntry(LootManager.createLootCapacitor(0.05f));
            lp.addEntry(LootManager.createLootEntry(ModObject.blockExitRail.getItemNN(), 1, 2, 0.15f));
        } else if (evt.getName().equals((Object)LootTableList.field_186425_g)) {
            lp.addEntry(LootManager.createDarkSteelLootEntry(ModObject.itemDarkSteelBoots.getItemNN(), 0.1f));
            lp.addEntry(LootManager.createLootEntry(Material.GEAR_IRON.getStack(), 1, 2, 0.5f));
            lp.addEntry(LootManager.createLootCapacitor(0.15f));
        } else if (evt.getName().equals((Object)LootTableList.field_186431_m)) {
            CapturedMob polarBear = CapturedMob.create(new ResourceLocation(RL_MINECRAFT, "polar_bear"));
            if (polarBear != null) {
                lp.addEntry((LootEntry)new LootEntryItem(ModObject.itemSoulVial.getItemNN(), 1, 1, new LootFunction[]{LootManager.setCount(1, 1), new SetNBT(NO_CONDITIONS, polarBear.toNbt(null))}, new LootCondition[]{new RandomChance(0.2f)}, "PolarBearSoulVial"));
            }
            lp.addEntry(LootManager.createLootEntry(ModObject.itemSoulVial.getItemNN(), 1, 3, 0.5f));
            lp.addEntry(LootManager.createLootCapacitor(0.05f));
        } else if (evt.getName().equals((Object)LootTableList.field_189420_m)) {
            ItemStack bucket = Fluids.FIRE_WATER.getBucket();
            lp.addEntry((LootEntry)new LootEntryItem(bucket.func_77973_b(), 1, 1, new LootFunction[]{LootManager.setCount(1, 1), LootManager.setMetadata(bucket.func_77960_j()), LootManager.setNBT(bucket)}, new LootCondition[]{new RandomChance(0.05f)}, bucket.func_77973_b().func_77658_a() + ":" + bucket.func_77960_j()));
        } else if (evt.getName().equals((Object)LootTableList.field_186423_e)) {
            lp.addEntry(LootManager.createLootEntry(Alloy.ELECTRICAL_STEEL.getStackIngot(), 2, 6, 0.2f));
            lp.addEntry(LootManager.createLootEntry(Alloy.REDSTONE_ALLOY.getStackIngot(), 3, 6, 0.35f));
            lp.addEntry(LootManager.createLootEntry(Alloy.DARK_STEEL.getStackIngot(), 3, 6, 0.35f));
            lp.addEntry(LootManager.createLootEntry(Alloy.PULSATING_IRON.getStackIngot(), 1, 2, 0.3f));
            lp.addEntry(LootManager.createLootEntry(Alloy.VIBRANT_ALLOY.getStackIngot(), 1, 2, 0.2f));
            lp.addEntry(LootManager.createLootEntry(Material.GEAR_WOOD.getStack(), 1, 2, 0.5f));
            lp.addEntry(LootManager.createLootEntry(Material.GEAR_STONE.getStack(), 1, 2, 0.4f));
            lp.addEntry(LootManager.createLootEntry(Material.GEAR_IRON.getStack(), 1, 2, 0.25f));
            lp.addEntry(LootManager.createLootEntry(Material.GEAR_ENERGIZED.getStack(), 1, 2, 0.125f));
            lp.addEntry(LootManager.createLootEntry(Material.GEAR_VIBRANT.getStack(), 1, 2, 0.0625f));
            lp.addEntry(LootManager.createDarkSteelLootEntry(ModObject.itemDarkSteelSword.getItemNN(), 1, 1, 0.25f));
            lp.addEntry(LootManager.createDarkSteelLootEntry(ModObject.itemDarkSteelBoots.getItemNN(), 1, 1, 0.25f));
            lp.addEntry(LootManager.createLootCapacitor(0.1f));
        } else if (evt.getName().equals((Object)LootTableList.field_186429_k)) {
            lp.addEntry(LootManager.createDarkSteelLootEntry(ModObject.itemDarkSteelSword.getItemNN(), 0.2f));
            lp.addEntry(LootManager.createLootEntry(Material.GEAR_VIBRANT.getStack(), 1, 2, 0.0625f));
            lp.addEntry(LootManager.createLootEntry(ModObject.itemTravelStaff.getItemNN(), 0.1f));
            lp.addEntry(LootManager.createLootCapacitor(0.5f));
        } else if (evt.getName().equals((Object)LootTableList.field_186430_l)) {
            lp.addEntry(LootManager.createDarkSteelLootEntry(ModObject.itemDarkSteelSword.getItemNN(), 1, 1, 0.25f));
            lp.addEntry(LootManager.createLootEntry(ModObject.itemTravelStaff.getItemNN(), 1, 1, 0.1f));
            lp.addEntry(LootManager.createLootCapacitor(0.25f));
            lp.addEntry(LootManager.createLootCapacitor(0.25f));
        } else if (evt.getName().equals((Object)LootTableList.field_191192_o)) {
            lp.addEntry(LootManager.createDarkSteelLootEntry(ModObject.itemDarkSteelBow.getItemNN(), 1, 1, 0.25f));
            lp.addEntry(LootManager.createDarkSteelLootEntry(ModObject.itemDarkSteelAxe.getItemNN(), 1, 1, 0.25f));
            lp.addEntry(LootManager.createLootEntry(Material.GEAR_STONE.getStack(), 1, 2, 0.4f));
            lp.addEntry(LootManager.createLootCapacitor(0.25f));
            lp.addEntry(LootManager.createLootEntry(ModObject.itemTravelStaff.getItemNN(), 1, 1, 0.1f));
        } else if (evt.getName().equals((Object)LootTableList.field_186421_c)) {
            CapturedMob shulker = CapturedMob.create(new ResourceLocation(RL_MINECRAFT, "shulker"));
            if (shulker != null) {
                lp.addEntry((LootEntry)new LootEntryItem(ModObject.itemSoulVial.getItemNN(), 1, 1, new LootFunction[]{LootManager.setCount(1, 1), new SetNBT(NO_CONDITIONS, shulker.toNbt(null))}, new LootCondition[]{new RandomChance(0.2f)}, "ShulkerSoulVial"));
            }
            lp.addEntry(LootManager.createLootEntry(ModObject.itemSoulVial.getItemNN(), 1, 3, 0.5f));
            lp.addEntry(LootManager.createLootEntry(Material.GEAR_ENERGIZED.getStack(), 1, 2, 0.125f));
            lp.addEntry(LootManager.createLootEntry(Material.GEAR_VIBRANT.getStack(), 1, 2, 0.125f));
            lp.addEntry(LootManager.createLootCapacitor(0.05f));
            lp.addEntry(LootManager.createDarkSteelLootEntry(ModObject.itemDarkSteelBow.getItemNN(), 1, 1, 0.25f));
        } else {
            return;
        }
        if (table.isFrozen()) {
            throw new RuntimeException("Some other mod (a list of suspects is printed in the log file) put a frozen loot table into the load event for loot table '" + evt.getName() + "'. This is a bug in that other mod. Ender IO is the victim here. Don't blame the victim!");
        }
        table.addPool(lp);
    }

    private static void addTable(@Nonnull LootPool pool, @Nonnull ResourceLocation resourceLocation) {
        pool.addEntry((LootEntry)new LootEntryTable(resourceLocation, 1, 1, NO_CONDITIONS, resourceLocation.toString()));
    }

    @Nonnull
    private static LootEntry createLootEntry(@Nonnull Item item, float chance) {
        return LootManager.createLootEntry(item, 1, 1, chance);
    }

    @Nonnull
    private static LootEntry createLootEntry(@Nonnull Item item, int minSize, int maxSize, float chance) {
        return LootManager.createLootEntry(item, 0, minSize, maxSize, chance);
    }

    @Nonnull
    private static LootEntry createLootEntry(@Nonnull Item item, int meta, int minStackSize, int maxStackSize, float chance) {
        LootCondition[] chanceCond = new LootCondition[]{new RandomChance(chance)};
        ResourceLocation registryName = (ResourceLocation)NullHelper.notnull((Object)item.getRegistryName(), (String)ERROR_UNREGISTERED_ITEM);
        if (item.func_77645_m()) {
            return new LootEntryItem(item, 1, 1, new LootFunction[]{LootManager.setCount(minStackSize, maxStackSize), LootManager.setDamage(item, meta), LootManager.setEnergy()}, chanceCond, registryName.toString() + ":" + meta);
        }
        return new LootEntryItem(item, 1, 1, new LootFunction[]{LootManager.setCount(minStackSize, maxStackSize), LootManager.setMetadata(meta)}, chanceCond, registryName.toString() + ":" + meta);
    }

    @Nonnull
    private static LootEntry createLootEntry(@Nonnull ItemStack stack, int minStackSize, int maxStackSize, float chance) {
        LootCondition[] chanceCond = new LootCondition[]{new RandomChance(chance)};
        ResourceLocation registryName = (ResourceLocation)NullHelper.notnull((Object)stack.func_77973_b().getRegistryName(), (String)ERROR_UNREGISTERED_ITEM);
        return new LootEntryItem(stack.func_77973_b(), 1, 1, new LootFunction[]{LootManager.setCount(minStackSize, maxStackSize), LootManager.setMetadata(stack.func_77960_j())}, chanceCond, registryName.toString() + ":" + stack.func_77960_j());
    }

    @Nonnull
    private static LootEntry createDarkSteelLootEntry(@Nonnull Item item, float chance) {
        return LootManager.createDarkSteelLootEntry(item, 1, 1, chance);
    }

    @Nonnull
    private static LootEntry createDarkSteelLootEntry(@Nonnull Item item, int minSize, int maxSize, float chance) {
        return LootManager.createDarkSteelLootEntry(item, 0, minSize, maxSize, chance);
    }

    @Nonnull
    private static LootEntry createDarkSteelLootEntry(@Nonnull Item item, int meta, int minStackSize, int maxStackSize, float chance) {
        LootCondition[] chanceCond = new LootCondition[]{new RandomChance(chance)};
        ResourceLocation registryName = (ResourceLocation)NullHelper.notnull((Object)item.getRegistryName(), (String)ERROR_UNREGISTERED_ITEM);
        return new LootEntryItem(item, 1, 1, new LootFunction[]{LootManager.setCount(minStackSize, maxStackSize), LootManager.setDamage(item, meta), LootManager.setUpgrades(), LootManager.setEnergy()}, chanceCond, registryName.toString() + ":" + meta);
    }

    @Nonnull
    private static LootEntry createLootCapacitor(float chance) {
        return new LootEntryItem(ModObject.itemBasicCapacitor.getItemNN(), 1, 1, new LootFunction[]{ls, LootManager.setMetadata(3, 4)}, new LootCondition[]{new RandomChance(chance)}, ModObject.itemBasicCapacitor.getUnlocalisedName() + ++capCount);
    }

    @Nonnull
    private static SetCount setCount(int min, int max) {
        return new SetCount(NO_CONDITIONS, new RandomValueRange((float)min, (float)min));
    }

    @Nonnull
    private static SetDamage setDamage(Item item, int damage) {
        return new SetDamage(NO_CONDITIONS, new RandomValueRange(damage > 0 ? (float)damage : 1.0f, damage > 0 ? (float)damage : (float)item.func_77612_l()));
    }

    @Nonnull
    private static SetMetadata setMetadata(int metaMin, int metaMax) {
        return new SetMetadata(NO_CONDITIONS, new RandomValueRange((float)metaMin, (float)metaMax));
    }

    @Nonnull
    private static SetMetadata setMetadata(int meta) {
        return new SetMetadata(NO_CONDITIONS, new RandomValueRange((float)meta));
    }

    @Nonnull
    private static SetRandomEnergy setEnergy() {
        return new SetRandomEnergy(NO_CONDITIONS);
    }

    @Nonnull
    private static SetRandomDarkUpgrade setUpgrades() {
        return new SetRandomDarkUpgrade(NO_CONDITIONS);
    }

    @Nonnull
    private static SetNBT setNBT(ItemStack stack) {
        return new SetNBT(NO_CONDITIONS, (NBTTagCompound)NullHelper.first((Object[])new NBTTagCompound[]{stack.func_77978_p(), new NBTTagCompound()}));
    }

    @Nonnull
    private static ResourceLocation eio(ResourceLocation mc) {
        return new ResourceLocation("enderio", mc.func_110623_a());
    }

    static {
        MC_TABLES.add(LootTableList.field_186422_d);
        MC_TABLES.add(LootTableList.field_186424_f);
        MC_TABLES.add(LootTableList.field_186425_g);
        MC_TABLES.add(LootTableList.field_186431_m);
        MC_TABLES.add(LootTableList.field_189420_m);
        MC_TABLES.add(LootTableList.field_186423_e);
        MC_TABLES.add(LootTableList.field_186429_k);
        MC_TABLES.add(LootTableList.field_186430_l);
        MC_TABLES.add(LootTableList.field_191192_o);
        MC_TABLES.add(LootTableList.field_186421_c);
        capCount = 0;
        ls = new LootSelector(NO_CONDITIONS);
    }
}

