/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.upgrades;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IRule;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.base.xp.XpUtil;
import crazypants.enderio.util.NbtValue;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.util.Strings;

public final class ItemUpgrades
extends Item
implements IHaveRenderers,
IAdvancedTooltipProvider {
    @Nonnull
    private static final String INVENTORY = "inventory";

    public static ItemUpgrades create(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemUpgrades(modObject);
    }

    private ItemUpgrades(@Nonnull IModObject modObject) {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
    }

    public int getItemStackLimit(@Nonnull ItemStack stack) {
        return stack.func_77952_i() > 0 ? 1 : 64;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(modObject.getRegistryName(), INVENTORY)});
        UpgradeRegistry.getUpgrades().apply(upgrade -> {
            ResourceLocation registryName = upgrade.getRegistryName();
            if (registryName != null) {
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{this.getMRL(modObject.getRegistryName(), registryName)});
            }
        });
        ModelLoader.setCustomMeshDefinition((Item)this, this::getMRL);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    protected ModelResourceLocation getMRL(@Nonnull ItemStack stack) {
        ResourceLocation registryName;
        IDarkSteelUpgrade upgrade = ItemUpgrades.getUpgrade(stack);
        if (upgrade != null && (registryName = upgrade.getRegistryName()) != null) {
            return this.getMRL(this.getRegistryName(), registryName);
        }
        return new ModelResourceLocation((ResourceLocation)NullHelper.first((Object)this.getRegistryName(), (Supplier[])new Supplier[0]), INVENTORY);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    protected ModelResourceLocation getMRL(ResourceLocation base, @Nonnull ResourceLocation registryName) {
        return new ModelResourceLocation(new ResourceLocation(registryName.func_110624_b(), base.func_110623_a()), "upgrade=" + registryName.func_110623_a());
    }

    public static IDarkSteelUpgrade getUpgrade(@Nonnull ItemStack stack) {
        String string;
        if (stack.func_77952_i() == 1 && !Strings.isBlank((String)(string = NbtValue.DSU.getString(stack)))) {
            return UpgradeRegistry.getUpgrade(new ResourceLocation(string));
        }
        return null;
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        IDarkSteelUpgrade upgrade = ItemUpgrades.getUpgrade(stack);
        if (upgrade != null) {
            return upgrade.getUnlocalizedName();
        }
        return this.func_77658_a();
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        IDarkSteelUpgrade upgrade = ItemUpgrades.getUpgrade(stack);
        if (upgrade != null) {
            return I18n.func_74837_a((String)(this.func_77658_a() + ".with"), (Object[])new Object[]{super.func_77653_i(stack)}).trim();
        }
        return super.func_77653_i(stack);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this));
            UpgradeRegistry.getUpgrades().apply(upgrade -> {
                list.add((Object)this.withUpgrade((IDarkSteelUpgrade)upgrade));
                list.add((Object)ItemUpgrades.setEnabled(this.withUpgrade((IDarkSteelUpgrade)upgrade), true));
            });
        }
    }

    @Nonnull
    public ItemStack withUpgrade(@Nonnull IDarkSteelUpgrade upgrade) {
        ResourceLocation registryName = upgrade.getRegistryName();
        if (registryName != null) {
            return NbtValue.DSU.setString(new ItemStack((Item)this, 1, 1), registryName.toString());
        }
        return new ItemStack((Item)this);
    }

    public static boolean isEnabled(@Nonnull ItemStack stack) {
        return NbtValue.ENABLED.getBoolean(stack);
    }

    @Nonnull
    public static ItemStack setEnabled(@Nonnull ItemStack stack, boolean value) {
        return NbtValue.ENABLED.setBoolean(stack, value);
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return ItemUpgrades.isEnabled(stack) || super.func_77636_d(stack);
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addCommonTooltipFromResources(list, (String)itemstack.func_77977_a());
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addBasicTooltipFromResources(list, (String)itemstack.func_77977_a());
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        IDarkSteelUpgrade upgrade = ItemUpgrades.getUpgrade(itemstack);
        if (upgrade != null) {
            list.add(Lang.DSU_TOOLTIP_MAIN.get());
            NNList sublist = new NNList();
            SpecialTooltipHandler.addDetailedTooltipFromResources((List)sublist, (String)upgrade.getUnlocalizedName());
            sublist.apply(line -> {
                if (!line.contains("$")) {
                    list.add(Lang.DSU_TOOLTIP_LINE.get(line));
                }
            });
            List<IDarkSteelUpgrade> dependencies = upgrade.getRules().stream().filter(rule -> rule instanceof IRule.Prerequisite).map(rule -> ((IRule.Prerequisite)rule).getPrerequisite()).collect(Collectors.toList());
            if (!dependencies.isEmpty()) {
                list.add(Lang.DSU_TOOLTIP_DEPS.get());
                dependencies.forEach(dependency -> list.add(Lang.DSU_TOOLTIP_LINE.get(dependency.getDisplayName())));
            }
            List<String> classes = upgrade.getRules().stream().filter(rule -> rule instanceof IRule.ItemType).map(rule -> ((IRule.ItemType)rule).getTooltip().func_150254_d()).collect(Collectors.toList());
            list.add(Lang.DSU_TOOLTIP_CLAS.get());
            if (classes.isEmpty()) {
                list.add(Lang.DSU_TOOLTIP_LINE.get(Lang.DSU_CLASS_EVERYTHING.get()));
            } else {
                classes.forEach(itemclass -> list.add(Lang.DSU_TOOLTIP_LINE.get(itemclass)));
            }
            if (!ItemUpgrades.isEnabled(itemstack)) {
                list.add(TextFormatting.LIGHT_PURPLE + Lang.DSU_TOOLTIP_LEVELS_1.get(upgrade.getLevelCost()));
                list.add(Lang.DSU_TOOLTIP_LEVELS_2.get());
            }
        } else {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)this.func_77658_a());
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        IDarkSteelUpgrade upgrade;
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                ModObject.blockDarkSteelAnvil.openGui(worldIn, new BlockPos(0, -1, 0), playerIn, null, -1);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!ItemUpgrades.isEnabled(stack) && stack.func_190916_E() == 1 && (upgrade = ItemUpgrades.getUpgrade(stack)) != null) {
            int levels = playerIn.field_71068_ca;
            int levelCost = upgrade.getLevelCost();
            if (levels >= levelCost || playerIn.field_71075_bZ.field_75098_d) {
                if (!worldIn.field_72995_K) {
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        int drainXP = XpUtil.getExperienceForLevel(levels) - XpUtil.getExperienceForLevel(levels - levelCost);
                        XpUtil.addPlayerXP(playerIn, -drainXP);
                    }
                    ItemUpgrades.setEnabled(stack, true);
                    playerIn.func_146105_b((ITextComponent)Lang.DSU_GUI_ACTIVATED.toChatServer(), true);
                }
            } else if (!worldIn.field_72995_K) {
                playerIn.func_146105_b((ITextComponent)Lang.DSU_GUI_NOT_ENOUGH_LEVELS.toChatServer(levelCost), true);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }
}

