/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.util;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class LangParser {
    private static final String[] EIO_OLD_PATHS = new String[]{"F:/github/manual/EnderIO_1102/resources/assets/enderio/lang/", "C:/github/EnderIO_110/resources/assets/enderio/lang/", "F:/github/manual/EnderIO_1710/resources/assets/enderio/lang/", "C:/github/EnderIO_1710/resources/assets/enderio/lang/", "F:/github/manual/EnderZoo_1122/resources/assets/enderzoo/lang/", "C:/github/EnderZoo/resources/assets/enderzoo/lang/", "F:/github/manual/EnderZoo/resources/assets/enderzoo/lang/", "C:/github/EnderZoo_1710/resources/assets/enderzoo/lang/"};
    private static String[] submods = new String[]{"enderio-base", "enderio-conduits", "enderio-integration-forestry", "enderio-integration-tic", "enderio-invpanel", "enderio-machines"};

    public static void main(String[] args) {
        for (String submod : submods) {
            System.out.println("Looking at " + submod);
            try {
                HashMap byKey = new HashMap();
                HashMap byVal = new HashMap();
                HashMap result = new HashMap();
                int langs = 0;
                int vals = 0;
                for (String path : EIO_OLD_PATHS) {
                    File[] files;
                    File f = new File(path);
                    if (!f.exists()) continue;
                    for (File file : files = f.listFiles()) {
                        if (!file.getName().endsWith(".lang")) continue;
                        String lang = file.getName().replaceAll("\\..*$", "").toLowerCase(Locale.ENGLISH);
                        if (!byVal.containsKey(lang)) {
                            byVal.put(lang, new HashMap());
                            result.put(lang, new HashMap());
                        }
                        List lines = FileUtils.readLines((File)file, (String)"UTF-8");
                        ++langs;
                        for (String line : lines) {
                            if ((line = line.trim()).startsWith("/") || line.startsWith("#") || line.startsWith(";") || !line.contains("=")) continue;
                            String[] split = line.split("=", 2);
                            String key = split[0].trim();
                            String val = split[1].trim();
                            if (val.isEmpty()) continue;
                            if (!byKey.containsKey(key)) {
                                byKey.put(key, new HashMap());
                            }
                            ((Map)byKey.get(key)).put(lang, val);
                            if (!((Map)byVal.get(lang)).containsKey(val)) {
                                ((Map)byVal.get(lang)).put(val, new HashSet());
                            }
                            ((Set)((Map)byVal.get(lang)).get(val)).add(key);
                            ++vals;
                        }
                    }
                }
                System.out.println("Read " + langs + " langs with " + vals + " values");
                for (File file : new File(submod + "/src/main/resources/assets/enderio/lang/").listFiles()) {
                    String lang;
                    if (!file.getName().endsWith(".lang") || result.containsKey(lang = file.getName().replaceAll("\\..*$", "").toLowerCase(Locale.ENGLISH))) continue;
                    result.put(lang, new HashMap());
                }
                File f2 = new File(submod + "/src/main/resources/assets/enderio/lang/en_us.lang");
                List lines = FileUtils.readLines((File)f2, (String)"UTF-8");
                for (String line : lines) {
                    if ((line = line.trim()).startsWith("/") || line.startsWith("#") || line.startsWith(";") || !line.contains("=")) continue;
                    String[] split = line.split("=", 2);
                    String key = split[0].trim();
                    String val = split[1].trim();
                    String offset = "                                                                                                              ".substring(0, key.length() - 4);
                    for (String lang : result.keySet()) {
                        HashSet guessValue = new HashSet();
                        String comment = "#" + offset + "en: " + val;
                        if (byKey.containsKey(key) && ((Map)byKey.get(key)).containsKey(lang)) {
                            guessValue.add(((Map)byKey.get(key)).get(lang));
                        }
                        if (((Map)byVal.get("en_us")).containsKey(val)) {
                            for (String possibleKey : (Set)((Map)byVal.get("en_us")).get(val)) {
                                if (!byKey.containsKey(possibleKey) || !((Map)byKey.get(possibleKey)).containsKey(lang)) continue;
                                guessValue.add(((Map)byKey.get(possibleKey)).get(lang));
                            }
                        }
                        if (guessValue.isEmpty()) {
                            ((Map)result.get(lang)).put(key, "\n" + comment);
                        } else {
                            ((Map)result.get(lang)).put(key, String.join((CharSequence)("\n#" + offset + "OR: "), guessValue) + "\n" + comment);
                        }
                        if (!"en_us".equals(lang)) continue;
                        ((Map)result.get(lang)).put(key, val);
                    }
                }
                for (File file : new File(submod + "/src/main/resources/assets/enderio/lang/").listFiles()) {
                    String lang;
                    if (!file.getName().endsWith(".lang") || "en_us".equals(lang = file.getName().replaceAll("\\..*$", "").toLowerCase(Locale.ENGLISH))) continue;
                    for (String line : FileUtils.readLines((File)file, (String)"UTF-8")) {
                        if ((line = line.trim()).startsWith("/") || line.startsWith("#") || line.startsWith(";") || !line.contains("=")) continue;
                        String[] split = line.split("=", 2);
                        String key = split[0].trim();
                        if (((Map)result.get(lang)).remove(key) == null) {
                            ((Map)result.get(lang)).put("# " + key, " <-- extra unused key");
                            continue;
                        }
                        if (LangParser.placeholders(split[1]) == LangParser.placeholders((String)((Map)result.get("en_us")).get(key))) continue;
                        ((Map)result.get(lang)).put("# " + key, " <-- different number of %s\n#  ('" + split[1] + "' vs '" + (String)((Map)result.get("en_us")).get(key) + "')");
                    }
                }
                result.remove("en_us");
                for (String lang : result.keySet()) {
                    lines.clear();
                    for (String key : ((Map)result.get(lang)).keySet()) {
                        lines.add(key + "=" + (String)((Map)result.get(lang)).get(key));
                    }
                    File f3 = new File(submod + "/src/main/resources/assets/enderio/lang/" + lang + ".guess");
                    Collections.sort(lines);
                    lines.add(0, "# This file has been auto-generated by the 'LangParser' tool. Do NOT edit!");
                    lines.add(1, "#");
                    lines.add(2, "# Edit the .lang file instead. You may have to create it first.");
                    lines.add(3, "#");
                    System.out.println("Writing guess file for " + lang + " with " + lines.size() + " lines");
                    FileUtils.writeLines((File)f3, (String)"UTF-8", (Collection)lines);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static int placeholders(String s) {
        return s.replaceAll("[^%]", "").length();
    }
}

