/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Action;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.event.AvailableActionsEvent;
import com.mrcrayfish.controllable.event.ControllerEvent;
import com.mrcrayfish.guns.MrCrayfishGunMod;
import com.mrcrayfish.guns.client.event.GunHandler;
import com.mrcrayfish.guns.client.event.ReloadHandler;
import com.mrcrayfish.guns.event.CommonEvents;
import com.mrcrayfish.guns.item.ItemGun;
import com.mrcrayfish.guns.item.ItemScope;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.MessageUnload;
import com.mrcrayfish.guns.object.Gun;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ControllerEvents {
    private boolean shooting = false;
    private int reloadCounter = -1;

    @SubscribeEvent
    public void onButtonInput(ControllerEvent.ButtonInput event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (player != null && world != null) {
            ItemStack heldItem = player.func_184614_ca();
            switch (event.getButton()) {
                case 12: {
                    if (!(heldItem.func_77973_b() instanceof ItemGun)) break;
                    event.setCanceled(true);
                    if (!event.getState()) break;
                    GunHandler.fire((EntityPlayer)player, heldItem);
                    break;
                }
                case 11: {
                    if (!(heldItem.func_77973_b() instanceof ItemGun)) break;
                    event.setCanceled(true);
                    break;
                }
                case 8: {
                    if (!(heldItem.func_77973_b() instanceof ItemGun)) break;
                    event.setCanceled(true);
                    break;
                }
                case 2: {
                    if (!(heldItem.func_77973_b() instanceof ItemGun)) break;
                    event.setCanceled(true);
                    if (!event.getState()) break;
                    this.reloadCounter = 0;
                }
            }
        }
    }

    @SubscribeEvent
    public void onControllerTurn(ControllerEvent.Turn event) {
        ItemStack heldItem;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (heldItem = player.func_184614_ca()).func_77973_b() instanceof ItemGun && MrCrayfishGunMod.proxy.isZooming()) {
            ItemScope.Type scopeType;
            event.setYawSpeed(10.0f);
            event.setPitchSpeed(7.5f);
            ItemStack scope = Gun.getScope(heldItem);
            if (scope != null && (scopeType = ItemScope.Type.getFromStack(scope)) != null) {
                switch (scopeType) {
                    case LONG: {
                        if (event.getController().getState().rightStickClick) {
                            event.setYawSpeed(1.5f);
                            event.setPitchSpeed(1.0f);
                            break;
                        }
                        event.setYawSpeed(3.5f);
                        event.setPitchSpeed(3.0f);
                        break;
                    }
                    case MEDIUM: {
                        event.setYawSpeed(6.66f);
                        event.setPitchSpeed(5.0f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void updateAvailableActions(AvailableActionsEvent event) {
        ItemStack heldItem;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (heldItem = player.func_184614_ca()).func_77973_b() instanceof ItemGun) {
            ItemScope.Type scopeType;
            ItemStack scope;
            event.getActions().put(11, new Action("Aim", Action.Side.RIGHT));
            event.getActions().put(12, new Action("Shoot", Action.Side.RIGHT));
            ItemGun itemGun = (ItemGun)heldItem.func_77973_b();
            NBTTagCompound tag = heldItem.func_77978_p();
            if (tag != null && tag.func_74762_e("AmmoCount") < itemGun.getGun().general.maxAmmo) {
                event.getActions().put(2, new Action("Reload", Action.Side.LEFT));
            }
            if ((scope = Gun.getScope(heldItem)) != null && MrCrayfishGunMod.proxy.isZooming() && (scopeType = ItemScope.Type.getFromStack(scope)) == ItemScope.Type.LONG) {
                event.getActions().put(8, new Action("Hold Breath", Action.Side.RIGHT));
            }
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        ItemStack heldItem;
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if ((double)controller.getState().rightTrigger > 0.05 && (heldItem = player.func_184614_ca()).func_77973_b() instanceof ItemGun) {
            Gun gun = ((ItemGun)heldItem.func_77973_b()).getModifiedGun(heldItem);
            if (gun.general.auto) {
                GunHandler.fire((EntityPlayer)player, heldItem);
            }
        }
        if (mc.field_71462_r == null && this.reloadCounter != -1 && controller.getState().x) {
            ++this.reloadCounter;
        }
        if (this.reloadCounter > 40) {
            ReloadHandler.setReloading(false);
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageUnload());
            this.reloadCounter = -1;
        } else if (this.reloadCounter > 0 && !controller.getState().x) {
            if (!((Boolean)Minecraft.func_71410_x().field_71439_g.func_184212_Q().func_187225_a(CommonEvents.RELOADING)).booleanValue()) {
                ReloadHandler.setReloading(true);
                ReloadHandler.reloadingSlot = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c;
            } else {
                ReloadHandler.setReloading(false);
            }
            this.reloadCounter = -1;
        }
    }
}

