/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.event;

import com.mrcrayfish.guns.init.ModSounds;
import com.mrcrayfish.guns.item.ItemGun;
import com.mrcrayfish.guns.object.Gun;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CommonEvents {
    public static final DataParameter<Boolean> AIMING = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> RELOADING = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final Map<UUID, CooldownTracker> COOLDOWN_TRACKER_MAP = new HashMap<UUID, CooldownTracker>();
    private Map<UUID, ReloadTracker> reloadTrackerMap = new HashMap<UUID, ReloadTracker>();

    public static CooldownTracker getCooldownTracker(UUID uuid) {
        if (!COOLDOWN_TRACKER_MAP.containsKey(uuid)) {
            COOLDOWN_TRACKER_MAP.put(uuid, new CooldownTracker());
        }
        return COOLDOWN_TRACKER_MAP.get(uuid);
    }

    @SubscribeEvent
    public void onPlayerInit(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityPlayer) {
            event.getEntity().func_184212_Q().func_187214_a(AIMING, (Object)false);
            event.getEntity().func_184212_Q().func_187214_a(RELOADING, (Object)false);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.field_70170_p.field_72995_K) {
            EntityPlayer player = event.player;
            if (((Boolean)player.func_184212_Q().func_187225_a(RELOADING)).booleanValue()) {
                ReloadTracker tracker;
                if (!this.reloadTrackerMap.containsKey(player.func_110124_au())) {
                    if (!(player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemGun)) {
                        player.func_184212_Q().func_187227_b(RELOADING, (Object)false);
                        return;
                    }
                    this.reloadTrackerMap.put(player.func_110124_au(), new ReloadTracker(player));
                }
                if (!(tracker = this.reloadTrackerMap.get(player.func_110124_au())).isSameWeapon(player) || tracker.isWeaponFull() || !tracker.hasAmmo(player)) {
                    this.reloadTrackerMap.remove(player.func_110124_au());
                    player.func_184212_Q().func_187227_b(RELOADING, (Object)false);
                    return;
                }
                if (tracker.canReload(player)) {
                    tracker.increaseAmmo(player);
                    if (tracker.isWeaponFull() || !tracker.hasAmmo(player)) {
                        this.reloadTrackerMap.remove(player.func_110124_au());
                        player.func_184212_Q().func_187227_b(RELOADING, (Object)false);
                    }
                }
            }
            CommonEvents.getCooldownTracker(player.func_110124_au()).func_185144_a();
        }
    }

    private static class ReloadTracker {
        private int startTick;
        private int slot;
        private ItemStack stack;
        private Gun gun;

        private ReloadTracker(EntityPlayer player) {
            this.startTick = player.field_70173_aa;
            this.slot = player.field_71071_by.field_70461_c;
            this.stack = player.field_71071_by.func_70448_g();
            this.gun = ((ItemGun)this.stack.func_77973_b()).getModifiedGun(this.stack);
        }

        public boolean isSameWeapon(EntityPlayer player) {
            return !this.stack.func_190926_b() && player.field_71071_by.field_70461_c == this.slot && player.field_71071_by.func_70448_g() == this.stack;
        }

        public boolean isWeaponFull() {
            NBTTagCompound tag;
            if (!this.stack.func_77942_o()) {
                this.stack.func_77982_d(new NBTTagCompound());
            }
            return (tag = this.stack.func_77978_p()).func_74762_e("AmmoCount") >= this.gun.general.maxAmmo;
        }

        public boolean hasAmmo(EntityPlayer player) {
            return ItemGun.findAmmo(player, this.gun.projectile.item) != null;
        }

        public boolean canReload(EntityPlayer player) {
            int deltaTicks = player.field_70173_aa - this.startTick;
            return deltaTicks > 0 && deltaTicks % 10 == 0;
        }

        public void increaseAmmo(EntityPlayer player) {
            String reloadSound;
            SoundEvent event;
            ItemStack ammo = ItemGun.findAmmo(player, this.gun.projectile.item);
            if (!ammo.func_190926_b()) {
                int amount = Math.min(ammo.func_190916_E(), this.gun.general.reloadSpeed);
                NBTTagCompound tag = this.stack.func_77978_p();
                if (tag != null) {
                    amount = Math.min(amount, this.gun.general.maxAmmo - tag.func_74762_e("AmmoCount"));
                    tag.func_74768_a("AmmoCount", tag.func_74762_e("AmmoCount") + amount);
                }
                ammo.func_190918_g(amount);
            }
            if ((event = ModSounds.getSound(reloadSound = this.gun.sounds.getReload(this.gun))) == null) {
                event = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(reloadSound));
            }
            if (event != null) {
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, event, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

