/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.network.message;

import com.mrcrayfish.guns.GunConfig;
import com.mrcrayfish.guns.MrCrayfishGunMod;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSound
implements IMessage,
IMessageHandler<MessageSound, IMessage> {
    private SoundEvent sound;
    private SoundCategory category;
    private int posX;
    private int posY;
    private int posZ;
    private float volume;
    private float pitch;

    public MessageSound() {
    }

    public MessageSound(SoundEvent sound, SoundCategory category, double posX, double posY, double posZ, float volume, float pitch) {
        this.sound = sound;
        this.category = category;
        this.posX = (int)(posX * 8.0);
        this.posY = (int)(posY * 8.0);
        this.posZ = (int)(posZ * 8.0);
        this.volume = volume;
        this.pitch = pitch;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(SoundEvent.field_187505_a.func_148757_b((Object)this.sound));
        buf.writeInt(this.category.ordinal());
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
    }

    public void fromBytes(ByteBuf buf) {
        this.sound = (SoundEvent)SoundEvent.field_187505_a.func_148754_a(buf.readInt());
        this.category = SoundCategory.values()[buf.readInt()];
        this.posX = buf.readInt();
        this.posY = buf.readInt();
        this.posZ = buf.readInt();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    public IMessage onMessage(MessageSound message, MessageContext ctx) {
        if (GunConfig.CLIENT.sound.hitSound) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> MrCrayfishGunMod.proxy.playClientSound(this.posX, this.posY, this.posZ, message.sound, message.category, message.volume, message.pitch));
        }
        return null;
    }
}

