/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dynmap.blockscan.blockstate.BaseCondition;

public class BlockStateOverrides {
    public Map<String, Map<String, BlockStateOverride>> overrides = Collections.emptyMap();
    public Map<String, Map<String, BlockTintOverride[]>> tinting = Collections.emptyMap();

    public BlockStateOverride getOverride(String modid, String blkid) {
        Map<String, BlockStateOverride> map = this.overrides.get(modid);
        if (map != null) {
            return map.get(blkid);
        }
        return null;
    }

    public BlockTintOverride getTinting(String modid, String blkid, Map<String, String> prop) {
        BlockTintOverride[] blkmatch;
        Map<String, BlockTintOverride[]> modmatch = this.tinting.get(modid);
        if (modmatch != null && (blkmatch = modmatch.get(blkid)) != null) {
            for (BlockTintOverride ovr : blkmatch) {
                if (ovr.state != null && !ovr.state.matches(prop)) continue;
                return ovr;
            }
        }
        return null;
    }

    public void merge(BlockStateOverrides ovr) {
        String modid;
        for (Map.Entry<String, Map<String, BlockStateOverride>> entry : ovr.overrides.entrySet()) {
            modid = entry.getKey();
            if (!this.overrides.containsKey(modid)) {
                this.overrides.put(modid, new HashMap());
            }
            Map<String, BlockStateOverride> bso = this.overrides.get(modid);
            for (Map.Entry<String, BlockStateOverride> blk : entry.getValue().entrySet()) {
                bso.put(blk.getKey(), blk.getValue());
            }
        }
        for (Map.Entry<String, Map<String, BlockStateOverride>> entry : ovr.tinting.entrySet()) {
            modid = entry.getKey();
            if (!this.tinting.containsKey(modid)) {
                this.tinting.put(modid, new HashMap());
            }
            Map<String, BlockTintOverride[]> bto = this.tinting.get(modid);
            for (Map.Entry<String, BlockStateOverride> blk : entry.getValue().entrySet()) {
                bto.put(blk.getKey(), (BlockTintOverride[])blk.getValue());
            }
        }
    }

    public static class BlockTintOverride {
        public BaseCondition state;
        public String[] colormap;

        public static class Deserializer
        implements JsonDeserializer<BlockTintOverride> {
            public BlockTintOverride deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
                BlockTintOverride ovr = new BlockTintOverride();
                JsonObject obj = element.getAsJsonObject();
                if (obj.has("state")) {
                    ovr.state = new BaseCondition(obj.get("state").getAsString());
                }
                if (obj.has("colormap")) {
                    JsonArray ary = obj.getAsJsonArray("colormap");
                    ovr.colormap = new String[ary.size()];
                    for (int i = 0; i < ary.size(); ++i) {
                        ovr.colormap[i] = ary.get(i).getAsString();
                    }
                }
                return ovr;
            }
        }
    }

    public static class BlockStateOverride {
        public String baseNameProperty = null;
        public String nameSuffix = "";
        public String blockStateName = null;
        public String blockStateKey = null;
        public String blockStateValue = null;
    }
}

