/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jline.internal.Log;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dynmap.blockscan.BlockStateOverrides;
import org.dynmap.blockscan.DynmapBlockScanMod;
import org.dynmap.blockscan.blockstate.BlockState;
import org.dynmap.blockscan.blockstate.Variant;
import org.dynmap.blockscan.blockstate.VariantList;
import org.dynmap.blockscan.model.BlockElement;
import org.dynmap.blockscan.model.BlockFace;
import org.dynmap.blockscan.model.BlockModel;
import org.dynmap.blockscan.statehandlers.BedMetadataStateHandler;
import org.dynmap.blockscan.statehandlers.DoorStateHandler;
import org.dynmap.blockscan.statehandlers.ForgeStateContainer;
import org.dynmap.blockscan.statehandlers.GateMetadataStateHandler;
import org.dynmap.blockscan.statehandlers.IStateHandler;
import org.dynmap.blockscan.statehandlers.IStateHandlerFactory;
import org.dynmap.blockscan.statehandlers.NSEWConnectedMetadataStateHandler;
import org.dynmap.blockscan.statehandlers.NSEWUConnectedMetadataStateHandler;
import org.dynmap.blockscan.statehandlers.PistonMetadataStateHandler;
import org.dynmap.blockscan.statehandlers.RedstoneWireStateHandler;
import org.dynmap.blockscan.statehandlers.SimpleMetadataStateHandler;
import org.dynmap.blockscan.statehandlers.SnowyMetadataStateHandler;
import org.dynmap.blockscan.statehandlers.StairMetadataStateHandler;
import org.dynmap.blockscan.statehandlers.StateContainer;
import org.dynmap.blockscan.util.Matrix3D;
import org.dynmap.blockscan.util.Vector3D;
import org.dynmap.modsupport.BlockSide;
import org.dynmap.modsupport.BlockTextureRecord;
import org.dynmap.modsupport.CuboidBlockModel;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModSupportAPI;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.PatchBlockModel;
import org.dynmap.modsupport.TextureFile;
import org.dynmap.modsupport.TextureModifier;
import org.dynmap.modsupport.TransparencyMode;
import org.dynmap.renderer.RenderPatchFactory;

public class DynmapBlockScanPlugin {
    public static OurLog logger = new OurLog();
    public static DynmapBlockScanPlugin plugin;
    private Map<EnumFacing, BlockSide> faceToSide = new HashMap<EnumFacing, BlockSide>();
    private BlockStateOverrides overrides;
    private IStateHandlerFactory[] state_handler = new IStateHandlerFactory[]{new NSEWConnectedMetadataStateHandler(), new NSEWUConnectedMetadataStateHandler(), new RedstoneWireStateHandler(), new GateMetadataStateHandler(), new StairMetadataStateHandler(), new DoorStateHandler(), new PistonMetadataStateHandler(), new SnowyMetadataStateHandler(), new BedMetadataStateHandler(), new SimpleMetadataStateHandler(true), new SimpleMetadataStateHandler(false)};
    private static Map<String, PathElement> assetmap;
    private ModSupportAPI dynmap_api;
    private Map<String, ModDynmapRec> modTextureDef = new HashMap<String, ModDynmapRec>();
    private Set<String> registeredBlockMeta = new HashSet<String>();

    public DynmapBlockScanPlugin(MinecraftServer srv) {
        plugin = this;
        this.faceToSide.put(EnumFacing.DOWN, BlockSide.FACE_0);
        this.faceToSide.put(EnumFacing.UP, BlockSide.FACE_1);
        this.faceToSide.put(EnumFacing.NORTH, BlockSide.FACE_2);
        this.faceToSide.put(EnumFacing.SOUTH, BlockSide.FACE_3);
        this.faceToSide.put(EnumFacing.WEST, BlockSide.FACE_4);
        this.faceToSide.put(EnumFacing.EAST, BlockSide.FACE_5);
    }

    private void addElement(String modid, String n) {
        PathElement pe;
        String[] tok = n.split("/");
        Map<String, PathElement> m = assetmap;
        for (int i = 0; i < tok.length - 1; ++i) {
            if (tok[i].equals(".")) continue;
            pe = m.get(tok[i]);
            if (pe == null) {
                pe = new PathDirectory(modid);
                m.put(tok[i], pe);
            } else if (!(pe instanceof PathDirectory)) {
                PathDirectory pe2 = new PathDirectory(modid);
                for (String mm : pe.modids) {
                    pe2.addModId(mm);
                }
                m.put(tok[i], pe2);
                pe = pe2;
            } else {
                pe.addModId(modid);
            }
            m = ((PathDirectory)pe).entries;
        }
        pe = m.get(tok[tok.length - 1]);
        if (pe == null) {
            pe = new PathElement(modid);
            m.put(tok[tok.length - 1], pe);
        } else {
            pe.addModId(modid);
        }
    }

    private static PathElement findElement(Map<String, PathElement> m, String pth) {
        String[] tok = pth.split("/");
        for (int i = 0; i < tok.length - 1; ++i) {
            if (tok[i].equals(".")) continue;
            PathElement pe = m.get(tok[i]);
            if (pe instanceof PathDirectory) {
                m = ((PathDirectory)pe).entries;
                continue;
            }
            return null;
        }
        return m.get(tok[tok.length - 1]);
    }

    private static String scanForElement(Map<String, PathElement> m, String base, String fname) {
        for (Map.Entry<String, PathElement> me : m.entrySet()) {
            PathElement p = me.getValue();
            if (p instanceof PathDirectory) {
                PathDirectory pd = (PathDirectory)p;
                String rslt = DynmapBlockScanPlugin.scanForElement(pd.entries, base + "/" + me.getKey(), fname);
                if (rslt == null) continue;
                return rslt;
            }
            if (!me.getKey().equals(fname)) continue;
            return base + "/" + me.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildAssetMap() {
        assetmap = new HashMap<String, PathElement>();
        List mcl = Loader.instance().getModList();
        for (ModContainer mc : mcl) {
            String mid = mc.getModId().toLowerCase();
            File src = mc.getSource();
            if (!src.isFile() || !src.canRead()) continue;
            ZipFile zf = null;
            int cnt = 0;
            try {
                zf = new ZipFile(src);
                if (zf != null) {
                    Enumeration<? extends ZipEntry> zenum = zf.entries();
                    while (zenum.hasMoreElements()) {
                        ZipEntry ze = zenum.nextElement();
                        String n = ze.getName().replace('\\', '/');
                        if (!n.startsWith("assets/")) continue;
                        this.addElement(mid, n);
                        ++cnt;
                    }
                }
            }
            catch (IOException e) {
                logger.severe("Error opening mod - " + src.getPath());
            }
            finally {
                if (zf != null) {
                    try {
                        zf.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            logger.info("modid: " + mid + ", src=" + src.getAbsolutePath() + ", cnt=" + cnt);
        }
    }

    public void onEnable() {
    }

    public void onDisable() {
    }

    public void serverStarted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStarting() {
        this.buildAssetMap();
        InputStream override_str = DynmapBlockScanPlugin.openResource("dynmapblockscan", "blockstateoverrides.json");
        if (override_str != null) {
            InputStreamReader rdr = new InputStreamReader(override_str, Charsets.UTF_8);
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter(BlockStateOverrides.BlockTintOverride.class, (Object)new BlockStateOverrides.BlockTintOverride.Deserializer());
            Gson parse = gsonBuilder.create();
            JsonReader jrdr = new JsonReader((Reader)rdr);
            jrdr.setLenient(true);
            this.overrides = (BlockStateOverrides)parse.fromJson(jrdr, BlockStateOverrides.class);
            try {
                override_str.close();
            }
            catch (IOException iOException) {}
        } else {
            logger.info("Failed to load block overrides");
            this.overrides = new BlockStateOverrides();
        }
        for (Map.Entry entry : Loader.instance().getIndexedModList().entrySet()) {
            InputStream str = DynmapBlockScanPlugin.openAssetResource((String)entry.getKey(), "dynmap", "blockstateoverrides.json", true);
            if (str == null) continue;
            InputStreamReader rdr = new InputStreamReader(str, Charsets.UTF_8);
            GsonBuilder gb = new GsonBuilder();
            gb.registerTypeAdapter(BlockStateOverrides.BlockTintOverride.class, (Object)new BlockStateOverrides.BlockTintOverride.Deserializer());
            Gson parse = gb.create();
            try {
                JsonReader jsonReader = new JsonReader((Reader)rdr);
                jsonReader.setLenient(true);
                BlockStateOverrides modoverrides = (BlockStateOverrides)parse.fromJson(jsonReader, BlockStateOverrides.class);
                if (modoverrides == null) continue;
                this.overrides.merge(modoverrides);
                logger.info("Loaded dynmap overrides from " + (String)entry.getKey());
            }
            catch (JsonIOException jsonIOException) {
                logger.severe("Error reading dynmap overrides from " + (String)entry.getKey(), jsonIOException);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                logger.severe("Error parsing dynmap overrides from " + (String)entry.getKey(), jsonSyntaxException);
            }
            finally {
                if (str == null) continue;
                try {
                    str.close();
                }
                catch (IOException iOException) {}
            }
        }
        HashMap<String, BlockRecord> blockRecords = new HashMap<String, BlockRecord>();
        HashMap<String, BlockModel> hashMap = new HashMap<String, BlockModel>();
        for (Block b : Block.field_149771_c) {
            ResourceLocation rl = b.getRegistryName();
            BlockStateContainer bsc = b.func_176194_O();
            boolean bl = false;
            boolean uses_nonmodel = false;
            for (IBlockState bs : bsc.func_177619_a()) {
                switch (bs.func_185901_i()) {
                    case MODEL: {
                        bl = true;
                        break;
                    }
                    case INVISIBLE: {
                        uses_nonmodel = true;
                        if (!DynmapBlockScanMod.verboselogging) break;
                        logger.info(String.format("%s: Invisible block - nothing to render", rl));
                        break;
                    }
                    case ENTITYBLOCK_ANIMATED: {
                        uses_nonmodel = true;
                        if (!DynmapBlockScanMod.verboselogging) break;
                        logger.info(String.format("%s: Animated block - needs to be handled specially", rl));
                        break;
                    }
                    case LIQUID: {
                        uses_nonmodel = true;
                        if (!DynmapBlockScanMod.verboselogging) break;
                        logger.info(String.format("%s: Liquid block - special handling", rl));
                    }
                }
            }
            if (!bl) continue;
            if (uses_nonmodel) {
                logger.warning(String.format("%s: Block mixes model and nonmodel state handling!", rl));
            }
            Map<String, List<String>> propMap = this.buildPropoertMap(bsc);
            BlockState blockstate = DynmapBlockScanPlugin.loadBlockState(rl.func_110624_b(), rl.func_110623_a(), this.overrides, propMap);
            BlockRecord br = new BlockRecord();
            if (blockstate != null) {
                br.renderProps = blockstate.getRenderProps();
            }
            br.sc = new ForgeStateContainer(b, br.renderProps, propMap);
            if (blockstate != null) {
                IStateHandlerFactory[] ovr = this.overrides.getOverride(rl.func_110624_b(), rl.func_110623_a());
                br.varList = new HashMap<StateContainer.StateRec, List<VariantList>>();
                for (StateContainer.StateRec sr : br.sc.getValidStates()) {
                    Map<String, String> prop = sr.getProperties();
                    if (ovr != null && ovr.blockStateKey != null && ovr.blockStateValue != null) {
                        prop = new HashMap<String, String>(prop);
                        prop.put(ovr.blockStateKey, ovr.blockStateValue);
                    }
                    List<VariantList> vlist = blockstate.getMatchingVariants(prop, hashMap);
                    br.varList.put(sr, vlist);
                }
            } else {
                br.varList = Collections.emptyMap();
            }
            br.handler = null;
            for (IStateHandlerFactory f : this.state_handler) {
                br.handler = f.canHandleBlockState(br.sc);
                if (br.handler != null) break;
            }
            if (br.handler == null) {
                logger.info(rl + ":  NO MATCHING HANDLER");
            }
            blockRecords.put(rl.toString(), br);
        }
        logger.info("Loading models....");
        for (String blkname : blockRecords.keySet()) {
            BlockRecord br = (BlockRecord)blockRecords.get(blkname);
            if (br.sc == null) continue;
            for (Map.Entry entry : br.varList.entrySet()) {
                for (VariantList vl : (List)entry.getValue()) {
                    for (Variant va : vl.variantList) {
                        if (va.model == null) continue;
                        String[] tok = va.model.split(":");
                        if (tok.length == 1) {
                            tok = new String[]{"minecraft", "block/" + tok[0]};
                        } else {
                            tok[1] = "block/" + tok[1];
                        }
                        String modid = tok[0] + ":" + tok[1];
                        BlockModel mod = (BlockModel)hashMap.get(modid);
                        if (mod == null) {
                            mod = DynmapBlockScanPlugin.loadBlockModelFile(tok[0], tok[1]);
                            hashMap.put(modid, mod);
                        }
                        va.modelID = modid;
                    }
                }
            }
        }
        logger.info("Variant models loaded");
        LinkedList modelToResolve = new LinkedList(hashMap.values());
        while (!modelToResolve.isEmpty()) {
            BlockModel mod = (BlockModel)modelToResolve.pop();
            if (mod.parent == null) continue;
            String modid = mod.parent;
            if (modid.indexOf(58) < 0) {
                modid = "minecraft:" + modid;
            }
            mod.parentModel = (BlockModel)hashMap.get(modid);
            if (mod.parentModel != null) continue;
            String[] tok = modid.split(":");
            mod.parentModel = DynmapBlockScanPlugin.loadBlockModelFile(tok[0], tok[1]);
            hashMap.put(modid, mod.parentModel);
            modelToResolve.push(mod.parentModel);
        }
        logger.info("Parent models loaded and resolved");
        for (String blkname : blockRecords.keySet()) {
            BlockRecord br = (BlockRecord)blockRecords.get(blkname);
            if (br.sc == null) continue;
            for (Map.Entry<StateContainer.StateRec, List<VariantList>> var : br.varList.entrySet()) {
                ArrayList<BlockElement> elems = new ArrayList<BlockElement>();
                for (VariantList vl : var.getValue()) {
                    if (vl.variantList.size() <= 0) continue;
                    Variant va = vl.variantList.get(0);
                    if (!va.generateElements(hashMap)) {
                        logger.debug(va.toString() + ": failed to generate elements for " + blkname + "[" + var.getKey() + "]");
                        continue;
                    }
                    elems.addAll(va.elements);
                }
                if (elems.size() == 1 && ((BlockElement)elems.get(0)).isSimpleBlock()) {
                    if (br.handler == null) continue;
                    this.registerSimpleDynmapCubes(blkname, var.getKey(), (BlockElement)elems.get(0), br.sc.getBlockType());
                    continue;
                }
                if (this.isSimpleCuboid(elems)) {
                    if (br.handler == null) continue;
                    this.registerSimpleDynmapCuboids(blkname, var.getKey(), elems, br.sc.getBlockType());
                    continue;
                }
                if (br.handler == null) continue;
                this.registerDynmapPatches(blkname, var.getKey(), elems, br.sc.getBlockType());
            }
        }
        logger.info("Elements generated");
        this.publishDynmapModData();
        assetmap = null;
    }

    private ModDynmapRec getModRec(String modid) {
        ModDynmapRec td;
        if (this.dynmap_api == null) {
            this.dynmap_api = ModSupportAPI.getAPI();
            if (this.dynmap_api == null) {
                return null;
            }
        }
        if ((td = this.modTextureDef.get(modid)) == null) {
            td = new ModDynmapRec();
            td.txtDef = this.dynmap_api.getModTextureDefinition(modid, null);
            if (td.txtDef == null) {
                return null;
            }
            this.modTextureDef.put(modid, td);
            if (DynmapBlockScanMod.verboselogging) {
                logger.debug("Create dynmap mod record for " + modid);
            }
        }
        return td;
    }

    private int[] pruneDuplicateMeta(String blkname, int[] meta) {
        ArrayList<Integer> goodmeta = new ArrayList<Integer>();
        for (int mv : meta) {
            String blkid = blkname + ":" + mv;
            if (this.registeredBlockMeta.contains(blkid)) continue;
            this.registeredBlockMeta.add(blkid);
            goodmeta.add(mv);
        }
        if (meta.length != goodmeta.size()) {
            int[] newmeta = new int[goodmeta.size()];
            for (int i = 0; i < newmeta.length; ++i) {
                newmeta[i] = (Integer)goodmeta.get(i);
            }
            meta = newmeta;
        }
        return meta;
    }

    public void registerSimpleDynmapCubes(String blkname, StateContainer.StateRec state, BlockElement element, StateContainer.WellKnownBlockClasses type) {
        String[] tok = blkname.split(":");
        String modid = tok[0];
        String blknm = tok[1];
        int[] meta = state.metadata;
        if (tok[0].equals("minecraft")) {
            return;
        }
        if ((meta = this.pruneDuplicateMeta(blkname, meta)).length == 0) {
            return;
        }
        ModDynmapRec td = this.getModRec(modid);
        BlockTextureRecord btr = td.getBlockTxtRec(blknm, meta);
        if (btr == null) {
            return;
        }
        boolean tinting = false;
        for (BlockFace blockFace : element.faces.values()) {
            if (blockFace.tintindex < 0) continue;
            tinting = true;
            break;
        }
        if (tinting) {
            String txtfile = null;
            BlockStateOverrides.BlockTintOverride blockTintOverride = this.overrides.getTinting(modid, blknm, state.getProperties());
            if (blockTintOverride == null) {
                switch (type) {
                    case LEAVES: 
                    case VINES: {
                        txtfile = "minecraft:colormap/foliage";
                        break;
                    }
                    default: {
                        txtfile = "minecraft:colormap/grass";
                        break;
                    }
                }
            } else {
                txtfile = blockTintOverride.colormap[0];
            }
            if (txtfile != null) {
                TextureFile gtf = td.registerBiomeTexture(txtfile);
                btr.setBlockColorMapTexture(gtf);
            }
        }
        for (Map.Entry entry : element.faces.entrySet()) {
            EnumFacing facing = (EnumFacing)entry.getKey();
            BlockFace f = (BlockFace)entry.getValue();
            BlockSide bs = this.faceToSide.get(facing);
            if (bs == null || f.texture == null) continue;
            TextureFile gtf = td.registerTexture(f.texture);
            int faceidx = 360 - f.rotation;
            if (!element.uvlock) {
                faceidx += f.facerotation;
            }
            TextureModifier tm = TextureModifier.NONE;
            switch (faceidx % 360) {
                case 90: {
                    tm = TextureModifier.ROT90;
                    break;
                }
                case 180: {
                    tm = TextureModifier.ROT180;
                    break;
                }
                case 270: {
                    tm = TextureModifier.ROT270;
                }
            }
            btr.setSideTexture(gtf, tm, bs);
        }
    }

    public boolean isSimpleCuboid(List<BlockElement> elements) {
        for (BlockElement be : elements) {
            if (be.isSimpleCuboid()) continue;
            return false;
        }
        return true;
    }

    public void registerSimpleDynmapCuboids(String blkname, StateContainer.StateRec state, List<BlockElement> elems, StateContainer.WellKnownBlockClasses type) {
        String[] tok = blkname.split(":");
        String modid = tok[0];
        String blknm = tok[1];
        int[] meta = state.metadata;
        if (tok[0].equals("minecraft")) {
            return;
        }
        if ((meta = this.pruneDuplicateMeta(blkname, meta)).length == 0) {
            return;
        }
        ModDynmapRec td = this.getModRec(modid);
        BlockTextureRecord btr = td.getBlockTxtRec(blknm, meta);
        if (btr == null) {
            return;
        }
        boolean tinting = false;
        boolean culling = false;
        block8: for (BlockElement be : elems) {
            for (BlockFace f : be.faces.values()) {
                if (f.tintindex >= 0) {
                    tinting = true;
                    continue block8;
                }
                if (f.cullface == null) continue;
                culling = true;
            }
        }
        if (culling) {
            btr.setTransparencyMode(TransparencyMode.SEMITRANSPARENT);
        } else {
            btr.setTransparencyMode(TransparencyMode.TRANSPARENT);
        }
        if (tinting) {
            String txtfile = null;
            BlockStateOverrides.BlockTintOverride ovr = this.overrides.getTinting(modid, blknm, state.getProperties());
            if (ovr == null) {
                switch (type) {
                    case LEAVES: 
                    case VINES: {
                        txtfile = "minecraft:colormap/foliage";
                        break;
                    }
                    default: {
                        txtfile = "minecraft:colormap/grass";
                        break;
                    }
                }
            } else {
                txtfile = ovr.colormap[0];
            }
            if (txtfile != null) {
                TextureFile gtf = td.registerBiomeTexture(txtfile);
                btr.setBlockColorMapTexture(gtf);
            }
        }
        CuboidBlockModel mod = td.getCuboidModelRec(blknm, meta);
        int imgidx = 0;
        int[] cuboididx = new int[6];
        for (BlockElement be : elems) {
            for (int v = 0; v < cuboididx.length; ++v) {
                cuboididx[v] = -1;
            }
            for (Map.Entry<EnumFacing, BlockFace> face : be.faces.entrySet()) {
                EnumFacing facing = face.getKey();
                BlockFace f = face.getValue();
                if (f.texture == null) continue;
                TextureFile gtf = td.registerTexture(f.texture);
                int faceidx = 360 - f.rotation;
                if (!be.uvlock) {
                    faceidx += f.facerotation;
                }
                TextureModifier tm = TextureModifier.NONE;
                switch (faceidx % 360) {
                    case 90: {
                        tm = TextureModifier.ROT90;
                        break;
                    }
                    case 180: {
                        tm = TextureModifier.ROT180;
                        break;
                    }
                    case 270: {
                        tm = TextureModifier.ROT270;
                    }
                }
                cuboididx[facing.func_176745_a()] = imgidx;
                btr.setPatchTexture(gtf, tm, imgidx);
                ++imgidx;
            }
            mod.addCuboid((double)be.from[0] / 16.0, (double)be.from[1] / 16.0, (double)be.from[2] / 16.0, (double)be.to[0] / 16.0, (double)be.to[1] / 16.0, (double)be.to[2] / 16.0, cuboididx);
        }
    }

    public void registerDynmapPatches(String blkname, StateContainer.StateRec state, List<BlockElement> elems, StateContainer.WellKnownBlockClasses type) {
        String[] tok = blkname.split(":");
        String modid = tok[0];
        String blknm = tok[1];
        int[] meta = state.metadata;
        if (tok[0].equals("minecraft")) {
            return;
        }
        if ((meta = this.pruneDuplicateMeta(blkname, meta)).length == 0) {
            return;
        }
        ModDynmapRec td = this.getModRec(modid);
        BlockTextureRecord btr = td.getBlockTxtRec(blknm, meta);
        if (btr == null) {
            return;
        }
        boolean tinting = false;
        boolean culling = false;
        block8: for (BlockElement be : elems) {
            for (BlockFace f : be.faces.values()) {
                if (f.tintindex >= 0) {
                    tinting = true;
                    continue block8;
                }
                if (f.cullface == null) continue;
                culling = true;
            }
        }
        if (culling) {
            btr.setTransparencyMode(TransparencyMode.SEMITRANSPARENT);
        } else {
            btr.setTransparencyMode(TransparencyMode.TRANSPARENT);
        }
        if (tinting) {
            String txtfile = null;
            BlockStateOverrides.BlockTintOverride ovr = this.overrides.getTinting(modid, blknm, state.getProperties());
            if (ovr == null) {
                switch (type) {
                    case LEAVES: 
                    case VINES: {
                        txtfile = "minecraft:colormap/foliage";
                        break;
                    }
                    default: {
                        txtfile = "minecraft:colormap/grass";
                        break;
                    }
                }
            } else {
                txtfile = ovr.colormap[0];
            }
            if (txtfile != null) {
                TextureFile gtf = td.registerBiomeTexture(txtfile);
                btr.setBlockColorMapTexture(gtf);
            }
        }
        PatchBlockModel mod = td.getPatchModelRec(blknm, meta);
        int patchidx = 0;
        for (BlockElement be : elems) {
            for (Map.Entry<EnumFacing, BlockFace> face : be.faces.entrySet()) {
                EnumFacing facing = face.getKey();
                BlockFace f = face.getValue();
                BlockSide bs = this.faceToSide.get(facing);
                if (bs == null || f.texture == null) continue;
                TextureFile gtf = td.registerTexture(f.texture);
                int faceidx = 360 - f.rotation;
                if (!be.uvlock) {
                    faceidx += f.facerotation;
                }
                TextureModifier tm = TextureModifier.NONE;
                switch (faceidx % 360) {
                    case 90: {
                        tm = TextureModifier.ROT90;
                        break;
                    }
                    case 180: {
                        tm = TextureModifier.ROT180;
                        break;
                    }
                    case 270: {
                        tm = TextureModifier.ROT270;
                    }
                }
                if (this.addPatch(mod, facing, be) != null) {
                    btr.setPatchTexture(gtf, tm, patchidx);
                    ++patchidx;
                    continue;
                }
                logger.info("Failed to add patch for " + blkname);
            }
        }
    }

    private String addPatch(PatchBlockModel mod, EnumFacing facing, BlockElement be) {
        Vector3D fromvec = new Vector3D(be.from[0], be.from[1], be.from[2]);
        Vector3D tovec = new Vector3D(be.to[0], be.to[1], be.to[2]);
        Vector3D originvec = new Vector3D();
        Vector3D uvec = new Vector3D();
        Vector3D vvec = new Vector3D();
        switch (facing) {
            case DOWN: {
                originvec.x = fromvec.x;
                originvec.y = fromvec.y;
                originvec.z = fromvec.z;
                uvec.x = tovec.x;
                uvec.y = fromvec.y;
                uvec.z = fromvec.z;
                vvec.x = fromvec.x;
                vvec.y = fromvec.y;
                vvec.z = tovec.z;
                break;
            }
            case UP: {
                originvec.x = fromvec.x;
                originvec.y = tovec.y;
                originvec.z = tovec.z;
                uvec.x = tovec.x;
                uvec.y = tovec.y;
                uvec.z = tovec.z;
                vvec.x = fromvec.x;
                vvec.y = tovec.y;
                vvec.z = fromvec.z;
                break;
            }
            case WEST: {
                originvec.x = fromvec.x;
                originvec.y = fromvec.y;
                originvec.z = fromvec.z;
                uvec.x = fromvec.x;
                uvec.y = fromvec.y;
                uvec.z = tovec.z;
                vvec.x = fromvec.x;
                vvec.y = tovec.y;
                vvec.z = fromvec.z;
                break;
            }
            case EAST: {
                originvec.x = tovec.x;
                originvec.y = fromvec.y;
                originvec.z = tovec.z;
                uvec.x = tovec.x;
                uvec.y = fromvec.y;
                uvec.z = fromvec.z;
                vvec.x = tovec.x;
                vvec.y = tovec.y;
                vvec.z = tovec.z;
                break;
            }
            case NORTH: {
                originvec.x = tovec.x;
                originvec.y = fromvec.y;
                originvec.z = fromvec.z;
                uvec.x = fromvec.x;
                uvec.y = fromvec.y;
                uvec.z = fromvec.z;
                vvec.x = tovec.x;
                vvec.y = tovec.y;
                vvec.z = fromvec.z;
                break;
            }
            case SOUTH: {
                originvec.x = fromvec.x;
                originvec.y = fromvec.y;
                originvec.z = tovec.z;
                uvec.x = tovec.x;
                uvec.y = fromvec.y;
                uvec.z = tovec.z;
                vvec.x = fromvec.x;
                vvec.y = tovec.y;
                vvec.z = tovec.z;
            }
        }
        if (be.rotation != null && be.rotation.angle != 0.0f) {
            Matrix3D rot = new Matrix3D();
            Vector3D scale = new Vector3D(1.0, 1.0, 1.0);
            double rescale = 1.0 / Math.cos(Math.toRadians(be.rotation.angle)) - 1.0;
            if ("z".equals(be.rotation.axis)) {
                rot.rotateXY(be.rotation.angle);
                scale.x += rescale;
                scale.y += rescale;
            } else if ("x".equals(be.rotation.axis)) {
                rot.rotateYZ(be.rotation.angle);
                scale.y += rescale;
                scale.z += rescale;
            } else {
                rot.rotateXZ(be.rotation.angle);
                scale.x += rescale;
                scale.z += rescale;
            }
            Vector3D axis = be.rotation.origin != null ? new Vector3D(be.rotation.origin[0], be.rotation.origin[1], be.rotation.origin[2]) : new Vector3D(8.0, 8.0, 8.0);
            originvec.subtract(axis);
            uvec.subtract(axis);
            vvec.subtract(axis);
            rot.transform(originvec);
            rot.transform(uvec);
            rot.transform(vvec);
            if (be.rotation.rescale) {
                originvec.scale(scale);
                uvec.scale(scale);
                vvec.scale(scale);
            }
            originvec.add(axis);
            uvec.add(axis);
            vvec.add(axis);
        }
        originvec.scale(0.0625);
        uvec.scale(0.0625);
        vvec.scale(0.0625);
        return mod.addPatch(originvec.x, originvec.y, originvec.z, uvec.x, uvec.y, uvec.z, vvec.x, vvec.y, vvec.z, RenderPatchFactory.SideVisible.TOP);
    }

    public void publishDynmapModData() {
        for (ModDynmapRec mod : this.modTextureDef.values()) {
            if (mod.txtDef != null) {
                mod.txtDef.publishDefinition();
                logger.info("Published " + mod.txtDef.getModID() + " textures to Dynmap");
            }
            if (mod.modDef == null) continue;
            mod.modDef.publishDefinition();
            logger.info("Published " + mod.modDef.getModID() + " models to Dynmap");
        }
    }

    public static InputStream openAssetResource(String modid, String subpath, String resourcepath, boolean scan) {
        String pth = "assets/" + modid + "/" + subpath + "/" + resourcepath;
        PathElement pe = DynmapBlockScanPlugin.findElement(assetmap, pth);
        InputStream is = null;
        if (pe != null && (is = DynmapBlockScanPlugin.openResource(modid, pth)) == null) {
            for (String mid : pe.modids) {
                is = DynmapBlockScanPlugin.openResource(mid, pth);
                if (is == null) continue;
                return is;
            }
        }
        if (is == null && scan && (pe = DynmapBlockScanPlugin.findElement(assetmap, pth = "assets/" + modid + "/" + subpath)) instanceof PathDirectory && (pth = DynmapBlockScanPlugin.scanForElement(((PathDirectory)pe).entries, pth, resourcepath)) != null) {
            is = DynmapBlockScanPlugin.openResource(modid, pth);
        }
        return is;
    }

    public static InputStream openResource(String modid, String rname) {
        Object mod;
        String rname_lc = rname.toLowerCase();
        ModContainer mc = (ModContainer)Loader.instance().getIndexedModList().get(modid);
        Object object = mod = mc != null ? mc.getMod() : null;
        if (mod != null) {
            InputStream is = mod.getClass().getClassLoader().getResourceAsStream(rname);
            if (is == null) {
                is = mod.getClass().getClassLoader().getResourceAsStream(rname_lc);
            }
            if (is != null) {
                return is;
            }
        }
        return null;
    }

    public Map<String, List<String>> buildPropoertMap(BlockStateContainer bsc) {
        HashMap<String, List<String>> renderProperties = new HashMap<String, List<String>>();
        for (IProperty p : bsc.func_177623_d()) {
            String pn = p.func_177701_a();
            ArrayList<String> pvals = new ArrayList<String>();
            for (Comparable val : p.func_177700_c()) {
                if (val instanceof IStringSerializable) {
                    pvals.add(((IStringSerializable)val).func_176610_l());
                    continue;
                }
                pvals.add(val.toString());
            }
            renderProperties.put(pn, pvals);
        }
        return renderProperties;
    }

    public ImmutableMap<String, String> fromIBlockState(IBlockState bs) {
        ImmutableMap.Builder bld = ImmutableMap.builder();
        for (Map.Entry x : bs.func_177228_b().entrySet()) {
            Comparable v = (Comparable)x.getValue();
            if (v instanceof IStringSerializable) {
                bld.put((Object)((IProperty)x.getKey()).func_177701_a(), (Object)((IStringSerializable)v).func_176610_l());
                continue;
            }
            bld.put((Object)((IProperty)x.getKey()).func_177701_a(), (Object)v.toString());
        }
        return bld.build();
    }

    private static BlockState loadBlockState(String modid, String respath, BlockStateOverrides override, Map<String, List<String>> propMap) {
        BlockStateOverrides.BlockStateOverride ovr = override.getOverride(modid, respath);
        if (ovr == null) {
            return DynmapBlockScanPlugin.loadBlockStateFile(modid, respath);
        }
        if (ovr.blockStateName != null) {
            return DynmapBlockScanPlugin.loadBlockStateFile(modid, ovr.blockStateName);
        }
        if (ovr.baseNameProperty != null) {
            List<String> vals = propMap.get(ovr.baseNameProperty);
            if (vals == null) {
                Log.error((Object[])new Object[]{String.format("%s:%s : bad baseNameProperty=%s", modid, respath, ovr.baseNameProperty)});
                return null;
            }
            BlockState bs = new BlockState();
            bs.nestedProp = ovr.baseNameProperty;
            bs.nestedValueMap = new HashMap<String, BlockState>();
            for (String v : vals) {
                BlockState bs2 = DynmapBlockScanPlugin.loadBlockStateFile(modid, v + ovr.nameSuffix);
                if (bs2 == null) continue;
                bs.nestedValueMap.put(v, bs2);
            }
            return bs;
        }
        return null;
    }

    private static BlockState loadBlockStateFile(String modid, String respath) {
        String path = "assets/" + modid + "/blockstates/" + respath + ".json";
        BlockState bs = null;
        InputStream is = DynmapBlockScanPlugin.openAssetResource(modid, "blockstates", respath + ".json", true);
        if (is == null) {
            // empty if block
        }
        if (is != null) {
            InputStreamReader rdr = new InputStreamReader(is, Charsets.UTF_8);
            Gson parse = BlockState.buildParser();
            try {
                JsonReader jrdr = new JsonReader((Reader)rdr);
                jrdr.setLenient(true);
                bs = (BlockState)parse.fromJson(jrdr, BlockState.class);
            }
            catch (JsonSyntaxException jsx) {
                logger.warning(String.format("%s:%s : JSON syntax error in block state file", modid, path), jsx);
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bs == null) {
                logger.info(String.format("%s:%s : Failed to load blockstate!", modid, path));
            }
        } else {
            logger.info(String.format("%s:%s : Failed to open blockstate", modid, path));
        }
        return bs;
    }

    private static BlockModel loadBlockModelFile(String modid, String respath) {
        String path = "assets/" + modid + "/models/" + respath + ".json";
        BlockModel bs = null;
        InputStream is = DynmapBlockScanPlugin.openAssetResource(modid, "models", respath + ".json", true);
        if (is != null) {
            InputStreamReader rdr = new InputStreamReader(is, Charsets.UTF_8);
            Gson parse = BlockModel.buildParser();
            try {
                JsonReader jrdr = new JsonReader((Reader)rdr);
                jrdr.setLenient(true);
                bs = (BlockModel)parse.fromJson(jrdr, BlockModel.class);
            }
            catch (JsonSyntaxException jsx) {
                logger.warning(String.format("%s:%s : JSON syntax error in model file", modid, path), jsx);
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bs == null) {
                logger.info(String.format("%s:%s : Failed to load model!", modid, path));
                bs = new BlockModel();
            }
        } else {
            logger.info(String.format("%s:%s : Failed to open model", modid, path));
            bs = new BlockModel();
        }
        return bs;
    }

    public static class OurLog {
        Logger log = LogManager.getLogger((String)"DynmapBlockScan");
        public static final String DM = "";

        OurLog() {
        }

        public void debug(String s) {
            this.log.debug(DM + s);
        }

        public void info(String s) {
            this.log.info(DM + s);
        }

        public void severe(Throwable t) {
            this.log.fatal((Object)t);
        }

        public void severe(String s) {
            this.log.fatal(DM + s);
        }

        public void severe(String s, Throwable t) {
            this.log.fatal(DM + s, t);
        }

        public void verboseinfo(String s) {
            this.log.info(DM + s);
        }

        public void warning(String s) {
            this.log.warn(DM + s);
        }

        public void warning(String s, Throwable t) {
            this.log.warn(DM + s, t);
        }
    }

    private static class ModDynmapRec {
        ModTextureDefinition txtDef;
        ModModelDefinition modDef;
        Map<String, TextureFile> textureIDsByPath = new HashMap<String, TextureFile>();
        int nextTxtID = 1;

        private ModDynmapRec() {
        }

        public TextureFile registerTexture(String txtpath) {
            TextureFile txtf = this.textureIDsByPath.get(txtpath = txtpath.toLowerCase());
            if (txtf == null) {
                String txtid = String.format("txt%04d", this.nextTxtID);
                ++this.nextTxtID;
                String[] ptok = txtpath.split(":");
                String fname = "assets/" + ptok[0] + "/textures/" + ptok[1] + ".png";
                txtf = this.txtDef.registerTextureFile(txtid, fname);
                if (txtf != null) {
                    this.textureIDsByPath.put(txtpath, txtf);
                }
            }
            return txtf;
        }

        public TextureFile registerBiomeTexture(String txtpath) {
            TextureFile txtf = this.textureIDsByPath.get(txtpath);
            if (txtf == null) {
                String txtid = String.format("txt%04d", this.nextTxtID);
                ++this.nextTxtID;
                String[] ptok = txtpath.split(":");
                String fname = "assets/" + ptok[0] + "/textures/" + ptok[1] + ".png";
                txtf = this.txtDef.registerBiomeTextureFile(txtid, fname);
                if (txtf != null) {
                    this.textureIDsByPath.put(txtpath, txtf);
                }
            }
            return txtf;
        }

        public BlockTextureRecord getBlockTxtRec(String blknm, int[] meta) {
            BlockTextureRecord btr = this.txtDef.addBlockTextureRecord(blknm);
            if (btr == null) {
                return null;
            }
            if (DynmapBlockScanMod.verboselogging) {
                logger.debug("Created block record for " + blknm + Arrays.toString(meta));
            }
            for (int metaval : meta) {
                btr.setMetaValue(metaval);
            }
            return btr;
        }

        public CuboidBlockModel getCuboidModelRec(String blknm, int[] meta) {
            if (this.modDef == null) {
                this.modDef = this.txtDef.getModelDefinition();
            }
            CuboidBlockModel mod = this.modDef.addCuboidModel(blknm);
            if (DynmapBlockScanMod.verboselogging) {
                logger.debug("Created cuboid model for " + blknm + Arrays.toString(meta));
            }
            for (int metaval : meta) {
                mod.setMetaValue(metaval);
            }
            return mod;
        }

        public PatchBlockModel getPatchModelRec(String blknm, int[] meta) {
            if (this.modDef == null) {
                this.modDef = this.txtDef.getModelDefinition();
            }
            PatchBlockModel mod = this.modDef.addPatchModel(blknm);
            if (DynmapBlockScanMod.verboselogging) {
                logger.debug("Created patch model for " + blknm + Arrays.toString(meta));
            }
            for (int metaval : meta) {
                mod.setMetaValue(metaval);
            }
            return mod;
        }
    }

    private static class PathDirectory
    extends PathElement {
        Map<String, PathElement> entries = new HashMap<String, PathElement>();

        PathDirectory(String mid) {
            super(mid);
        }
    }

    private static class PathElement {
        String[] modids;

        PathElement(String mid) {
            this.modids = new String[]{mid};
        }

        void addModId(String mid) {
            this.modids = Arrays.copyOf(this.modids, this.modids.length + 1);
            this.modids[this.modids.length - 1] = mid;
        }
    }

    public static class BlockRecord {
        public StateContainer sc;
        public Map<StateContainer.StateRec, List<VariantList>> varList;
        public Set<String> renderProps;
        public IStateHandler handler;
    }
}

