/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.blockstate;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.dynmap.blockscan.blockstate.Condition;

public class BaseCondition
implements Condition {
    public final ImmutableMap<String, String> keyValuePairs;
    private final ImmutableMap<String, String[]> keyConditionalValuePairs;
    private final String unmatchedValue;

    public BaseCondition(ImmutableMap<String, String> v) {
        this.keyValuePairs = v;
        ImmutableMap.Builder bld = null;
        for (Map.Entry ent : v.entrySet()) {
            String entval = (String)ent.getValue();
            if (entval.indexOf(124) < 0) continue;
            if (bld == null) {
                bld = ImmutableMap.builder();
            }
            bld.put(ent.getKey(), (Object)entval.split("|"));
        }
        this.keyConditionalValuePairs = bld != null ? bld.build() : null;
        this.unmatchedValue = "";
    }

    public BaseCondition(String key) {
        String[] tok;
        String uv = "";
        ImmutableMap.Builder bld = ImmutableMap.builder();
        for (String t : tok = key.split(",")) {
            String[] kv = t.split("=");
            if (kv.length == 2) {
                bld.put((Object)kv[0], (Object)kv[1]);
                continue;
            }
            uv = kv[0];
        }
        this.keyValuePairs = bld.build();
        this.keyConditionalValuePairs = null;
        this.unmatchedValue = uv;
    }

    public String toString() {
        if (this.unmatchedValue.equals("")) {
            return this.keyValuePairs.toString();
        }
        return this.unmatchedValue;
    }

    public int hashCode() {
        return this.keyValuePairs.hashCode() ^ this.unmatchedValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BaseCondition) {
            BaseCondition bc = (BaseCondition)obj;
            return bc.keyValuePairs.equals(this.keyValuePairs) && bc.unmatchedValue.equals(this.unmatchedValue);
        }
        return false;
    }

    @Override
    public boolean matches(Map<String, String> props) {
        boolean is_match = true;
        for (Map.Entry es : this.keyValuePairs.entrySet()) {
            String esk = (String)es.getKey();
            String v = props.get(esk);
            if (v == null) {
                return false;
            }
            if (this.keyConditionalValuePairs != null && this.keyConditionalValuePairs.containsKey((Object)esk)) {
                String[] vals = (String[])this.keyConditionalValuePairs.get((Object)esk);
                boolean match = false;
                for (String mv : vals) {
                    if (!v.equals(mv)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            if (v.equals(es.getValue())) continue;
            return false;
        }
        if (this.keyValuePairs.isEmpty()) {
            is_match = this.unmatchedValue.equals("") || this.unmatchedValue.equals("normal");
        }
        return is_match;
    }

    @Override
    public void addPropKeys(Set<String> props) {
        props.addAll((Collection<String>)this.keyValuePairs.keySet());
    }
}

