/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.blockstate;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dynmap.blockscan.blockstate.BaseCondition;
import org.dynmap.blockscan.blockstate.Condition;
import org.dynmap.blockscan.blockstate.ForgeVariantV1;
import org.dynmap.blockscan.blockstate.ForgeVariantV1List;
import org.dynmap.blockscan.blockstate.Multipart;
import org.dynmap.blockscan.blockstate.Variant;
import org.dynmap.blockscan.blockstate.VariantList;
import org.dynmap.blockscan.blockstate.VariantListMap;
import org.dynmap.blockscan.model.BlockModel;

public class BlockState {
    private static Gson GSON;
    public int forge_marker = 0;
    public VariantListMap variants;
    public List<Multipart> multipart;
    public ForgeVariantV1 defaults;
    public Map<BaseCondition, ForgeVariantV1List> forge_variants;
    public String nestedProp = null;
    public Map<String, BlockState> nestedValueMap = null;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.variants != null) {
            sb.append("variants={").append(this.variants).append("}");
        }
        if (this.multipart != null) {
            sb.append("multipart=[").append(this.multipart).append("]");
        }
        return sb.toString();
    }

    public static Gson buildParser() {
        Gson g = GSON;
        if (g == null) {
            GsonBuilder gb = new GsonBuilder();
            gb.registerTypeAdapter(BlockState.class, (Object)new Deserializer());
            gb.registerTypeAdapter(Variant.class, (Object)new Variant.Deserializer());
            gb.registerTypeAdapter(VariantList.class, (Object)new VariantList.Deserializer());
            gb.registerTypeAdapter(ForgeVariantV1List.class, (Object)new ForgeVariantV1List.Deserializer());
            gb.registerTypeAdapter(ForgeVariantV1.class, (Object)new ForgeVariantV1.Deserializer());
            gb.registerTypeAdapter(VariantListMap.class, (Object)new VariantListMap.Deserializer());
            gb.registerTypeAdapter(Condition.class, (Object)new Condition.Deserializer());
            GSON = g = gb.create();
        }
        return g;
    }

    public Set<String> getRenderProps() {
        HashSet<String> props = new HashSet<String>();
        if (this.variants != null) {
            for (BaseCondition baseCondition : this.variants.map.keySet()) {
                baseCondition.addPropKeys(props);
            }
        }
        if (this.multipart != null) {
            for (Multipart multipart : this.multipart) {
                if (multipart.when == null) continue;
                multipart.when.addPropKeys(props);
            }
        }
        if (this.forge_variants != null) {
            for (Map.Entry entry : this.forge_variants.entrySet()) {
                BaseCondition bc = (BaseCondition)entry.getKey();
                bc.addPropKeys(props);
            }
        }
        return props;
    }

    public List<VariantList> getMatchingVariants(Map<String, String> prop, Map<String, BlockModel> models) {
        BlockState bs;
        String pval;
        List<VariantList> vlist = new ArrayList<VariantList>();
        if (this.variants != null) {
            for (Map.Entry var : this.variants.map.entrySet()) {
                if (!((BaseCondition)var.getKey()).matches(prop)) continue;
                vlist.add((VariantList)var.getValue());
                break;
            }
        }
        if (this.multipart != null) {
            for (Multipart mp : this.multipart) {
                if (mp.when == null) {
                    vlist.add(mp.apply);
                    continue;
                }
                if (!mp.when.matches(prop)) continue;
                vlist.add(mp.apply);
            }
        }
        if (this.forge_variants != null) {
            ForgeVariantV1List resolved = this.buildResolvedForgeList(prop);
            ArrayList<Variant> vanilla = new ArrayList<Variant>();
            for (ForgeVariantV1 var : resolved.variantList) {
                Variant v = var.generateVanilla(models);
                if (v == null) continue;
                vanilla.add(v);
            }
            vlist.add(new VariantList(vanilla));
        }
        if (this.nestedProp != null && (pval = prop.get(this.nestedProp)) != null && (bs = this.nestedValueMap(pval)) != null) {
            vlist = bs.getMatchingVariants(prop, models);
        }
        return vlist;
    }

    private BlockState nestedValueMap(String pval) {
        return null;
    }

    private ForgeVariantV1List buildResolvedForgeList(Map<String, String> prop) {
        ForgeVariantV1List varlist = new ForgeVariantV1List();
        for (Map.Entry<BaseCondition, ForgeVariantV1List> entry : this.forge_variants.entrySet()) {
            if (!entry.getKey().matches(prop)) continue;
            varlist.applyValues(entry.getValue(), false);
        }
        for (ForgeVariantV1 forgeVariantV1 : varlist.variantList) {
            forgeVariantV1.applyDefaults(this.defaults);
        }
        return varlist;
    }

    public static class Deserializer
    implements JsonDeserializer<BlockState> {
        public BlockState deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            BlockState bs = new BlockState();
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("forge_marker")) {
                bs.forge_marker = obj.get("forge_marker").getAsInt();
                if (obj.has("defaults")) {
                    bs.defaults = (ForgeVariantV1)context.deserialize((JsonElement)obj.getAsJsonObject("defaults"), ForgeVariantV1.class);
                }
                bs.forge_variants = new HashMap<BaseCondition, ForgeVariantV1List>();
                if (obj.has("variants")) {
                    for (Map.Entry e : obj.get("variants").getAsJsonObject().entrySet()) {
                        if (((JsonElement)e.getValue()).isJsonArray()) {
                            bs.forge_variants.put(new BaseCondition((String)e.getKey()), (ForgeVariantV1List)context.deserialize((JsonElement)e.getValue(), ForgeVariantV1List.class));
                            continue;
                        }
                        JsonObject vobj = ((JsonElement)e.getValue()).getAsJsonObject();
                        if (vobj.entrySet().iterator().hasNext() && ((JsonElement)((Map.Entry)vobj.entrySet().iterator().next()).getValue()).isJsonObject()) {
                            for (Map.Entry se : vobj.entrySet()) {
                                bs.forge_variants.put(new BaseCondition((String)e.getKey() + "=" + (String)se.getKey()), (ForgeVariantV1List)context.deserialize((JsonElement)se.getValue(), ForgeVariantV1List.class));
                            }
                            continue;
                        }
                        bs.forge_variants.put(new BaseCondition((String)e.getKey()), (ForgeVariantV1List)context.deserialize((JsonElement)e.getValue(), ForgeVariantV1List.class));
                    }
                }
            } else if (obj.has("multipart")) {
                bs.multipart = new ArrayList<Multipart>();
                for (JsonElement je : obj.getAsJsonArray("multipart")) {
                    bs.multipart.add((Multipart)context.deserialize(je, Multipart.class));
                }
            } else if (obj.has("variants")) {
                bs.variants = (VariantListMap)context.deserialize(obj.get("variants"), VariantListMap.class);
            }
            return bs;
        }
    }
}

