/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.blockstate;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.dynmap.blockscan.blockstate.ANDCondition;
import org.dynmap.blockscan.blockstate.BaseCondition;
import org.dynmap.blockscan.blockstate.ORCondition;

public interface Condition {
    public boolean matches(Map<String, String> var1);

    public void addPropKeys(Set<String> var1);

    public static class Deserializer
    implements JsonDeserializer<Condition> {
        public Condition deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            Condition cond;
            JsonObject obj = element.getAsJsonObject();
            if (obj.isJsonPrimitive()) {
                cond = new BaseCondition(obj.getAsString());
            } else if (obj.has("OR")) {
                JsonArray oval = obj.get("OR").getAsJsonArray();
                ORCondition ocond = new ORCondition();
                ocond.conditions = new ArrayList<BaseCondition>();
                for (JsonElement jsonelement : oval) {
                    ocond.conditions.add(this.parseBaseCondition(jsonelement.getAsJsonObject()));
                }
                cond = ocond;
            } else if (obj.has("AND")) {
                JsonArray aval = obj.get("AND").getAsJsonArray();
                ANDCondition acond = new ANDCondition();
                acond.conditions = new ArrayList<BaseCondition>();
                for (JsonElement jsonelement : aval) {
                    acond.conditions.add(this.parseBaseCondition(jsonelement.getAsJsonObject()));
                }
                cond = acond;
            } else {
                cond = this.parseBaseCondition(obj);
            }
            return cond;
        }

        private BaseCondition parseBaseCondition(JsonObject jsonelement) {
            ImmutableMap.Builder bld = ImmutableMap.builder();
            for (Map.Entry k : jsonelement.entrySet()) {
                bld.put(k.getKey(), (Object)((JsonElement)k.getValue()).getAsString());
            }
            return new BaseCondition((ImmutableMap<String, String>)bld.build());
        }
    }
}

