/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.blockstate;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dynmap.blockscan.blockstate.ForgeVariantV1List;
import org.dynmap.blockscan.blockstate.Variant;
import org.dynmap.blockscan.blockstate.VariantList;
import org.dynmap.blockscan.model.BlockModel;

public class ForgeVariantV1 {
    public String model;
    public Map<String, String> textures = new HashMap<String, String>();
    public Integer x;
    public Integer y;
    public Boolean uvlock;
    public Integer weight;
    public Boolean smooth_lighting;
    public Boolean gui3d;
    public Map<String, ForgeVariantV1List> submodel;
    public Map<String, Object> custom;

    public int hashCode() {
        return this.model.hashCode() ^ this.x ^ this.y << 8 ^ this.weight << 16 ^ (this.uvlock != false ? 12345 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ForgeVariantV1) {
            ForgeVariantV1 vobj = (ForgeVariantV1)obj;
            return this.model.equals(vobj.model) && this.x == vobj.x && this.y == vobj.y && this.uvlock == vobj.uvlock && this.weight == vobj.weight;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.model != null) {
            sb.append("model=").append(this.model);
        }
        if (this.x != null && this.x != 0) {
            sb.append(",x=").append(this.x);
        }
        if (this.y != null && this.y != 0) {
            sb.append(",y=").append(this.y);
        }
        if (this.uvlock != null && this.uvlock.booleanValue()) {
            sb.append(",uvlock=true");
        }
        if (this.weight != null && this.weight != 1) {
            sb.append(",weight=").append(this.weight);
        }
        if (this.textures != null && !this.textures.isEmpty()) {
            sb.append(",textures=" + this.textures);
        }
        if (this.submodel != null && !this.submodel.isEmpty()) {
            sb.append(",submodel=" + this.submodel);
        }
        sb.append("}");
        return sb.toString();
    }

    public void applyValues(ForgeVariantV1 src, boolean no_submodels) {
        if (src == null) {
            return;
        }
        if (this.model == null) {
            this.model = src.model;
        }
        for (Map.Entry<String, String> entry : src.textures.entrySet()) {
            if (this.textures.containsKey(entry.getKey())) continue;
            this.textures.put(entry.getKey(), entry.getValue());
        }
        if (this.x == null) {
            this.x = src.x;
        }
        if (this.y == null) {
            this.y = src.y;
        }
        if (this.uvlock == null) {
            this.uvlock = src.uvlock;
        }
        if (this.weight == null) {
            this.weight = src.weight;
        }
        if (this.smooth_lighting == null) {
            this.smooth_lighting = src.smooth_lighting;
        }
        if (this.gui3d == null) {
            this.gui3d = src.gui3d;
        }
        if (src.custom != null) {
            if (this.custom == null) {
                this.custom = new HashMap<String, Object>();
            }
            for (Map.Entry<String, Object> entry : src.custom.entrySet()) {
                String key = entry.getKey().toString();
                if (this.custom.containsKey(key)) continue;
                String val = entry.getValue().toString();
                this.custom.put(key, val);
            }
        }
        if (!no_submodels && src.submodel != null) {
            if (this.submodel == null) {
                this.submodel = new HashMap<String, ForgeVariantV1List>();
            }
            for (Map.Entry<String, Object> entry : src.submodel.entrySet()) {
                ForgeVariantV1List v1l = this.submodel.get(entry.getKey());
                if (v1l == null) {
                    v1l = new ForgeVariantV1List();
                    this.submodel.put(entry.getKey(), v1l);
                }
                v1l.applyValues((ForgeVariantV1List)entry.getValue(), true);
            }
        }
    }

    public void applyDefaults(ForgeVariantV1 defs) {
        if (defs != null) {
            this.applyValues(defs, true);
        }
        if (this.submodel != null) {
            for (Map.Entry<String, ForgeVariantV1List> ent : this.submodel.entrySet()) {
                ForgeVariantV1List v1l = this.submodel.get(ent.getKey());
                for (ForgeVariantV1 v1 : v1l.variantList) {
                    v1.applyValues(this, false);
                }
            }
        }
    }

    public Variant generateVanilla(Map<String, BlockModel> models) {
        String mod = this.model;
        if (this.textures != null && !this.textures.isEmpty() && this.model != null) {
            BlockModel bm = new BlockModel(mod, this.textures);
            int idx = models.size();
            String modid = "dynmapblockscan:block/forgemodel" + idx;
            while (models.containsKey(modid)) {
                modid = "dynmapblockscan:block/forgemodel" + ++idx;
            }
            models.put(modid, bm);
            mod = "dynmapblockscan:forgemodel" + idx;
        }
        Variant var = new Variant(mod, this.x, this.y, this.uvlock, this.weight);
        if (this.submodel != null) {
            ArrayList<Variant> vlist = new ArrayList<Variant>();
            for (ForgeVariantV1List subv : this.submodel.values()) {
                Variant sv;
                if (subv.variantList.size() <= 0 || (sv = subv.variantList.get(0).generateVanilla(models)) == null) continue;
                vlist.add(sv);
            }
            var.subvariants = new VariantList(vlist);
        }
        return var;
    }

    public static class Deserializer
    implements JsonDeserializer<ForgeVariantV1> {
        public ForgeVariantV1 deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            ForgeVariantV1 v = new ForgeVariantV1();
            JsonObject jobj = element.getAsJsonObject();
            if (jobj.has("model")) {
                v.model = jobj.get("model").getAsString();
            }
            if (jobj.has("textures")) {
                v.textures = (Map)context.deserialize(jobj.get("textures"), Map.class);
            }
            if (jobj.has("x")) {
                v.x = (Integer)context.deserialize(jobj.get("x"), Integer.class);
            }
            if (jobj.has("y")) {
                v.y = (Integer)context.deserialize(jobj.get("y"), Integer.class);
            }
            if (jobj.has("uvlock")) {
                v.uvlock = (Boolean)context.deserialize(jobj.get("uvlock"), Boolean.class);
            }
            if (jobj.has("weight")) {
                v.weight = (Integer)context.deserialize(jobj.get("weight"), Integer.class);
            }
            if (jobj.has("smooth_lighting")) {
                v.smooth_lighting = (Boolean)context.deserialize(jobj.get("smooth_lighting"), Boolean.class);
            }
            if (jobj.has("gui3d")) {
                v.gui3d = (Boolean)context.deserialize(jobj.get("gui3d"), Boolean.class);
            }
            if (jobj.has("submodel")) {
                JsonElement submod = jobj.get("submodel");
                v.submodel = new HashMap<String, ForgeVariantV1List>();
                if (submod.isJsonPrimitive()) {
                    ForgeVariantV1 v1 = new ForgeVariantV1();
                    v1.model = submod.getAsString();
                    v.submodel.put("simple", new ForgeVariantV1List(Collections.singletonList(v1)));
                } else {
                    for (Map.Entry vv : submod.getAsJsonObject().entrySet()) {
                        v.submodel.put((String)vv.getKey(), (ForgeVariantV1List)context.deserialize((JsonElement)vv.getValue(), ForgeVariantV1List.class));
                    }
                }
            }
            if (jobj.has("custom")) {
                v.custom = (Map)context.deserialize(jobj.get("custom"), Map.class);
            }
            return v;
        }
    }
}

