/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.blockstate;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import org.dynmap.blockscan.util.Matrix3D;
import org.dynmap.blockscan.util.Vector3D;

public enum ModelRotation {
    X0_Y0(0, 0),
    X0_Y90(0, 90),
    X0_Y180(0, 180),
    X0_Y270(0, 270),
    X90_Y0(90, 0),
    X90_Y90(90, 90),
    X90_Y180(90, 180),
    X90_Y270(90, 270),
    X180_Y0(180, 0),
    X180_Y90(180, 90),
    X180_Y180(180, 180),
    X180_Y270(180, 270),
    X270_Y0(270, 0),
    X270_Y90(270, 90),
    X270_Y180(270, 180),
    X270_Y270(270, 270);

    private static final Map<Integer, ModelRotation> MAP_ROTATIONS;
    private final int combinedXY;
    private final int quartersX;
    private final int quartersY;
    private EnumFacing[] facemap;
    private int[] facerot;
    private Matrix3D transform;

    private static int combineXY(int p_177521_0_, int p_177521_1_) {
        return p_177521_0_ * 360 + p_177521_1_;
    }

    private ModelRotation(int x, int y) {
        int i;
        EnumFacing f;
        this.combinedXY = ModelRotation.combineXY(x, y);
        this.quartersX = Math.abs(x / 90);
        this.quartersY = Math.abs(y / 90);
        this.facemap = new EnumFacing[6];
        this.facerot = new int[6];
        EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
        int n2 = enumFacingArray.length;
        for (int j = 0; j < n2; ++j) {
            this.facemap[f.func_176745_a()] = f = enumFacingArray[j];
            this.facerot[f.func_176745_a()] = 0;
        }
        for (i = 0; i < this.quartersX; ++i) {
            this.rotateX();
        }
        for (i = 0; i < this.quartersY; ++i) {
            this.rotateY();
        }
        EnumFacing[] newface = new EnumFacing[6];
        int[] newrot = new int[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            f = this.facemap[i2];
            newface[f.func_176745_a()] = EnumFacing.field_82609_l[i2];
            newrot[f.func_176745_a()] = this.facerot[i2];
        }
        this.facemap = newface;
        this.facerot = newrot;
        this.transform = new Matrix3D();
        if (this.quartersX != 0) {
            this.transform.rotateYZ(90.0 * (double)this.quartersX);
        }
        if (this.quartersY != 0) {
            this.transform.rotateXZ(90.0 * (double)this.quartersY);
        }
    }

    private void transferFace(EnumFacing src, EnumFacing dest, int rotation, EnumFacing[] newface, int[] newrot) {
        newface[dest.func_176745_a()] = this.facemap[src.func_176745_a()];
        newrot[dest.func_176745_a()] = (this.facerot[src.func_176745_a()] + rotation) % 4;
    }

    private void rotateX() {
        int[] newrot = new int[6];
        EnumFacing[] newface = new EnumFacing[6];
        this.transferFace(EnumFacing.WEST, EnumFacing.WEST, 1, newface, newrot);
        this.transferFace(EnumFacing.EAST, EnumFacing.EAST, 3, newface, newrot);
        this.transferFace(EnumFacing.SOUTH, EnumFacing.UP, 0, newface, newrot);
        this.transferFace(EnumFacing.NORTH, EnumFacing.DOWN, 2, newface, newrot);
        this.transferFace(EnumFacing.UP, EnumFacing.NORTH, 2, newface, newrot);
        this.transferFace(EnumFacing.DOWN, EnumFacing.SOUTH, 0, newface, newrot);
        this.facemap = newface;
        this.facerot = newrot;
    }

    private void rotateY() {
        int[] newrot = new int[6];
        EnumFacing[] newface = new EnumFacing[6];
        this.transferFace(EnumFacing.UP, EnumFacing.UP, 3, newface, newrot);
        this.transferFace(EnumFacing.DOWN, EnumFacing.DOWN, 1, newface, newrot);
        this.transferFace(EnumFacing.SOUTH, EnumFacing.WEST, 0, newface, newrot);
        this.transferFace(EnumFacing.WEST, EnumFacing.NORTH, 0, newface, newrot);
        this.transferFace(EnumFacing.NORTH, EnumFacing.EAST, 0, newface, newrot);
        this.transferFace(EnumFacing.EAST, EnumFacing.SOUTH, 0, newface, newrot);
        this.facemap = newface;
        this.facerot = newrot;
    }

    public EnumFacing rotateFace(EnumFacing facing) {
        return this.facemap[facing.func_176745_a()];
    }

    public int rotateFaceOrientation(EnumFacing facing) {
        return 90 * this.facerot[facing.func_176745_a()];
    }

    public void transformVector(Vector3D v) {
        this.transform.transform(v);
    }

    public static ModelRotation getModelRotation(int x, int y) {
        ModelRotation rot = MAP_ROTATIONS.get(ModelRotation.combineXY(ModelRotation.normalizeAngle(x, 360), ModelRotation.normalizeAngle(y, 360)));
        if (rot == null) {
            rot = X0_Y0;
        }
        return rot;
    }

    public static int normalizeAngle(int p_180184_0_, int p_180184_1_) {
        return (p_180184_0_ % p_180184_1_ + p_180184_1_) % p_180184_1_;
    }

    static {
        MAP_ROTATIONS = Maps.newHashMap();
        for (ModelRotation modelrotation : ModelRotation.values()) {
            MAP_ROTATIONS.put(modelrotation.combinedXY, modelrotation);
        }
    }
}

