/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.blockstate;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dynmap.blockscan.blockstate.ModelRotation;
import org.dynmap.blockscan.blockstate.VariantList;
import org.dynmap.blockscan.model.BlockElement;
import org.dynmap.blockscan.model.BlockModel;

public class Variant {
    public String model = "cube";
    public ModelRotation rotation = ModelRotation.X0_Y0;
    public boolean uvlock = false;
    public int weight = 1;
    public VariantList subvariants;
    public String modelID = "cube";
    public List<BlockElement> elements;

    public Variant() {
    }

    public Variant(String mod, Integer x, Integer y, Boolean uv, Integer wt) {
        this.model = this.modelID = mod;
        this.rotation = ModelRotation.getModelRotation(x != null ? x : 0, y != null ? y : 0);
        if (wt != null) {
            this.weight = wt;
        }
        if (uv != null) {
            this.uvlock = uv;
        }
    }

    public boolean generateElements(Map<String, BlockModel> models) {
        this.elements = new ArrayList<BlockElement>();
        BlockModel basemod = models.get(this.modelID);
        if (basemod != null) {
            BlockModel elemmod = basemod;
            while (elemmod.elements.isEmpty() && (elemmod = elemmod.parentModel) != null) {
            }
            if (elemmod != null) {
                for (BlockElement elem : elemmod.elements) {
                    this.elements.add(new BlockElement(elem, basemod, this.rotation, this.uvlock));
                }
            }
        }
        if (this.subvariants != null) {
            for (Variant subv : this.subvariants.variantList) {
                subv.generateElements(models);
                if (subv.elements == null) continue;
                this.elements.addAll(subv.elements);
            }
        }
        return this.elements.size() > 0;
    }

    public int hashCode() {
        return this.model.hashCode() ^ this.rotation.ordinal() ^ this.weight << 16 ^ (this.uvlock ? 12345 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Variant) {
            Variant vobj = (Variant)obj;
            return this.model.equals(vobj.model) && this.rotation == vobj.rotation && this.uvlock == vobj.uvlock && this.weight == vobj.weight;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("model=").append(this.model);
        sb.append(",rotation=").append((Object)this.rotation);
        if (this.uvlock) {
            sb.append(",uvlock=true");
        }
        if (this.weight != 1) {
            sb.append(",weight=").append(this.weight);
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Deserializer
    implements JsonDeserializer<Variant> {
        public Variant deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            Variant var = new Variant();
            JsonObject obj = element.getAsJsonObject();
            if (obj == null) {
                return var;
            }
            int x = 0;
            int y = 0;
            if (obj.has("x")) {
                x = obj.get("x").getAsInt();
            }
            if (obj.has("y")) {
                y = obj.get("y").getAsInt();
            }
            var.rotation = ModelRotation.getModelRotation(x, y);
            var.model = obj.has("model") ? obj.get("model").getAsString() : "cube";
            var.modelID = var.model;
            if (obj.has("uvlock")) {
                var.uvlock = obj.get("uvlock").getAsBoolean();
            }
            if (obj.has("weight")) {
                var.weight = obj.get("weight").getAsInt();
            }
            return var;
        }
    }
}

