/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import org.dynmap.blockscan.DynmapBlockScanPlugin;
import org.dynmap.blockscan.blockstate.ModelRotation;
import org.dynmap.blockscan.model.BlockFace;
import org.dynmap.blockscan.model.ElementRotation;
import org.dynmap.blockscan.model.TextureReferences;
import org.dynmap.blockscan.util.Vector3D;

public class BlockElement {
    public float[] from;
    public float[] to;
    public ElementRotation rotation = null;
    public Map<EnumFacing, BlockFace> faces = Collections.emptyMap();
    public boolean shade = true;
    public boolean uvlock = false;
    private static final Vector3D centervect = new Vector3D(8.0, 8.0, 8.0);

    public BlockElement() {
    }

    public BlockElement(BlockElement src, TextureReferences txtrefs, ModelRotation mrot, boolean uvlock) {
        this.from = Arrays.copyOf(src.from, src.from.length);
        this.to = Arrays.copyOf(src.to, src.to.length);
        if (src.rotation != null) {
            this.rotation = new ElementRotation(src.rotation);
        }
        this.shade = src.shade;
        this.faces = new HashMap<EnumFacing, BlockFace>();
        for (Map.Entry<EnumFacing, BlockFace> face : src.faces.entrySet()) {
            BlockFace f = face.getValue();
            String v = txtrefs.findTextureByID(f.texture);
            if (v == null) {
                DynmapBlockScanPlugin.logger.info("Unresolved texture ref: " + f.texture);
                DynmapBlockScanPlugin.logger.info(txtrefs.toString());
                continue;
            }
            this.faces.put(mrot.rotateFace(face.getKey()), new BlockFace(f, v, mrot.rotateFaceOrientation(face.getKey())));
        }
        Vector3D fromvec = new Vector3D(this.from[0], this.from[1], this.from[2]);
        Vector3D tovec = new Vector3D(this.to[0], this.to[1], this.to[2]);
        fromvec.subtract(centervect);
        tovec.subtract(centervect);
        mrot.transformVector(fromvec);
        mrot.transformVector(tovec);
        fromvec.add(centervect);
        tovec.add(centervect);
        this.from[0] = (float)Math.min(fromvec.x, tovec.x);
        this.from[1] = (float)Math.min(fromvec.y, tovec.y);
        this.from[2] = (float)Math.min(fromvec.z, tovec.z);
        this.to[0] = (float)Math.max(fromvec.x, tovec.x);
        this.to[1] = (float)Math.max(fromvec.y, tovec.y);
        this.to[2] = (float)Math.max(fromvec.z, tovec.z);
        this.uvlock = uvlock;
    }

    public boolean isSimpleCuboid() {
        return this.rotation == null || (double)this.rotation.angle == 0.0;
    }

    public boolean isSimpleBlock() {
        if (!this.isSimpleCuboid()) {
            return false;
        }
        if (this.from == null || this.from.length < 3 || this.from[0] != 0.0f || this.from[1] != 0.0f || this.from[2] != 0.0f) {
            return false;
        }
        if (this.to == null || this.to.length < 3 || this.to[0] != 16.0f || this.to[1] != 16.0f || this.to[2] != 16.0f) {
            return false;
        }
        for (EnumFacing f : EnumFacing.field_82609_l) {
            BlockFace ff = this.faces.get(f);
            if (ff != null && ff.isFullFace()) continue;
            return false;
        }
        return true;
    }

    public static class Deserializer
    implements JsonDeserializer<BlockElement> {
        public BlockElement deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            BlockElement be = new BlockElement();
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("from")) {
                be.from = (float[])context.deserialize(obj.get("from"), float[].class);
            }
            if (obj.has("to")) {
                be.to = (float[])context.deserialize(obj.get("to"), float[].class);
            }
            if (obj.has("rotation")) {
                be.rotation = (ElementRotation)context.deserialize(obj.get("rotation"), ElementRotation.class);
            }
            if (obj.has("faces")) {
                JsonObject f = obj.get("faces").getAsJsonObject();
                be.faces = new HashMap<EnumFacing, BlockFace>();
                for (Map.Entry fe : f.entrySet()) {
                    EnumFacing facing = EnumFacing.func_176739_a((String)((String)fe.getKey()));
                    if (facing == null) continue;
                    be.faces.put(facing, (BlockFace)context.deserialize((JsonElement)fe.getValue(), BlockFace.class));
                }
            }
            if (obj.has("shade")) {
                be.shade = obj.get("shade").getAsBoolean();
            }
            return be;
        }
    }
}

