/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dynmap.blockscan.model.BlockElement;
import org.dynmap.blockscan.model.TextureReferences;

public class BlockModel
implements TextureReferences {
    private static Gson GSON;
    public final List<BlockElement> elements = Collections.emptyList();
    public final boolean ambientOcclusion = true;
    public final Map<String, String> textures;
    public final String parent;
    public BlockModel parentModel = null;

    public BlockModel() {
        this.parent = null;
        this.textures = Collections.emptyMap();
    }

    public BlockModel(String par, Map<String, String> txt) {
        this.textures = new HashMap<String, String>();
        if (txt != null) {
            for (Map.Entry<String, String> ent : txt.entrySet()) {
                this.textures.put(ent.getKey(), ent.getValue());
            }
        }
        if (par != null) {
            String[] tok = par.split(":");
            par = tok.length == 1 ? "minecraft:block/" + tok[0] : tok[0] + ":block/" + tok[1];
            this.parent = par;
        } else {
            this.parent = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parent != null) {
            sb.append(" parent=").append(this.parent);
        }
        sb.append(" ambientOcclusion=true");
        if (!this.textures.isEmpty()) {
            sb.append(" textures=").append(this.textures);
        }
        if (!this.elements.isEmpty()) {
            sb.append(" elements=").append(this.elements);
        }
        sb.append("}");
        return sb.toString();
    }

    public static Gson buildParser() {
        Gson g = GSON;
        if (g == null) {
            GsonBuilder gb = new GsonBuilder();
            gb.registerTypeAdapter(BlockElement.class, (Object)new BlockElement.Deserializer());
            GSON = g = gb.create();
        }
        return g;
    }

    @Override
    public String findTextureByID(String txtid) {
        while (txtid.startsWith("#")) {
            BlockModel mod = this;
            boolean match = false;
            txtid = txtid.substring(1);
            while (!match) {
                if (mod.textures.containsKey(txtid)) {
                    match = true;
                    txtid = mod.textures.get(txtid);
                    continue;
                }
                mod = mod.parentModel;
                if (mod != null) continue;
                return null;
            }
        }
        if (txtid.indexOf(58) < 0) {
            txtid = "minecraft:" + txtid;
        }
        return txtid;
    }
}

