/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.statehandlers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dynmap.blockscan.statehandlers.IStateHandler;
import org.dynmap.blockscan.statehandlers.IStateHandlerFactory;
import org.dynmap.blockscan.statehandlers.StateContainer;

public class DoorStateHandler
implements IStateHandlerFactory {
    private static final String[] FACING = IStateHandlerFactory.facingValues;
    private static final String[] HALF = new String[]{"upper", "lower"};
    private static final String[] HINGE = new String[]{"left", "right"};

    @Override
    public IStateHandler canHandleBlockState(StateContainer bsc) {
        List<StateContainer.StateRec> state = bsc.getValidStates();
        if (bsc.getProperties().size() != 4 || state.size() != 32) {
            return null;
        }
        boolean facing = IStateHandlerFactory.findMatchingProperty(bsc, "facing", FACING);
        boolean half = IStateHandlerFactory.findMatchingProperty(bsc, "half", HALF);
        boolean hinge = IStateHandlerFactory.findMatchingProperty(bsc, "hinge", HINGE);
        if (!(facing && half && hinge)) {
            return null;
        }
        boolean open = IStateHandlerFactory.findMatchingBooleanProperty(bsc, "open");
        if (!open) {
            return null;
        }
        StateContainer.StateRec[] metavalues = new StateContainer.StateRec[32];
        for (StateContainer.StateRec s : state) {
            int idx = DoorStateHandler.getFacingIndex(s.getValue("facing")) + DoorStateHandler.getHingeIndex(s.getValue("hinge")) + DoorStateHandler.getHalfIndex(s.getValue("half")) + DoorStateHandler.getOpenIndex(s.getValue("open"));
            metavalues[idx] = s;
        }
        return new OurHandler(metavalues);
    }

    private static int getFacingIndex(String value) {
        for (int i = 0; i < FACING.length; ++i) {
            if (!FACING[i].equals(value)) continue;
            return 8 * i;
        }
        return 0;
    }

    private static int getHingeIndex(String value) {
        for (int i = 0; i < HINGE.length; ++i) {
            if (!HINGE[i].equals(value)) continue;
            return 2 * i;
        }
        return 0;
    }

    private static int getHalfIndex(String value) {
        for (int i = 0; i < HALF.length; ++i) {
            if (!HALF[i].equals(value)) continue;
            return 4 * i;
        }
        return 0;
    }

    private static int getOpenIndex(String value) {
        if (value.equals("true")) {
            return 1;
        }
        return 0;
    }

    class OurHandler
    implements IStateHandler {
        private String[] string_values = new String[32];
        private Map<String, String>[] map_values = new Map[32];

        OurHandler(StateContainer.StateRec[] states) {
            for (int i = 0; i < 32; ++i) {
                StateContainer.StateRec bs = states[i];
                HashMap<String, String> m = new HashMap<String, String>();
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, String> p : bs.getProperties().entrySet()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(p.getKey()).append("=").append(p.getValue());
                    m.put(p.getKey(), p.getValue());
                }
                this.map_values[i] = m;
                this.string_values[i] = sb.toString();
            }
        }

        @Override
        public String getName() {
            return "DoorMetadataState";
        }

        @Override
        public int getBlockStateIndex(int blockid, int blockmeta) {
            return blockmeta;
        }

        @Override
        public Map<String, String>[] getBlockStateValueMaps() {
            return this.map_values;
        }

        @Override
        public String[] getBlockStateValues() {
            return this.string_values;
        }
    }
}

