/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.statehandlers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.IStringSerializable;
import org.dynmap.blockscan.statehandlers.StateContainer;

public class ForgeStateContainer
extends StateContainer {
    public ForgeStateContainer(Block blk, Set<String> renderprops, Map<String, List<String>> propMap) {
        ImmutableList bsl = blk.func_176194_O().func_177619_a();
        IBlockState defstate = blk.func_176223_P();
        if (renderprops == null) {
            renderprops = new HashSet<String>();
            for (String pn : propMap.keySet()) {
                renderprops.add(pn);
            }
        }
        for (String pn : propMap.keySet()) {
            if (!renderprops.contains(pn)) continue;
            this.renderProperties.put(pn, propMap.get(pn));
        }
        this.defStateIndex = 0;
        for (IBlockState bs : bsl) {
            int meta = blk.func_176201_c(bs);
            ImmutableMap.Builder bld = ImmutableMap.builder();
            for (Map.Entry ent : bs.func_177228_b().entrySet()) {
                String pn = ((IProperty)ent.getKey()).func_177701_a();
                if (!renderprops.contains(pn)) continue;
                Object v = (Comparable)ent.getValue();
                if (v instanceof IStringSerializable) {
                    v = ((IStringSerializable)v).func_176610_l();
                }
                bld.put((Object)pn, (Object)v.toString());
            }
            StateContainer.StateRec sr = new StateContainer.StateRec(meta, (ImmutableMap<String, String>)bld.build());
            int prev_sr = this.records.indexOf(sr);
            if (prev_sr < 0) {
                if (bs.equals(defstate)) {
                    this.defStateIndex = this.records.size();
                }
                this.records.add(sr);
                continue;
            }
            StateContainer.StateRec prev = (StateContainer.StateRec)this.records.get(prev_sr);
            if (prev.hasMeta(meta)) continue;
            sr = new StateContainer.StateRec(prev, meta);
            this.records.set(prev_sr, sr);
            if (!bs.equals(defstate)) continue;
            this.defStateIndex = prev_sr;
        }
        if (blk instanceof BlockLeaves) {
            this.type = StateContainer.WellKnownBlockClasses.LEAVES;
        } else if (blk instanceof BlockCrops) {
            this.type = StateContainer.WellKnownBlockClasses.CROPS;
        } else if (blk instanceof BlockFlower) {
            this.type = StateContainer.WellKnownBlockClasses.FLOWER;
        } else if (blk instanceof BlockTallGrass) {
            this.type = StateContainer.WellKnownBlockClasses.TALLGRASS;
        } else if (blk instanceof BlockVine) {
            this.type = StateContainer.WellKnownBlockClasses.VINES;
        } else if (blk instanceof BlockBush) {
            this.type = StateContainer.WellKnownBlockClasses.BUSH;
        } else if (blk instanceof BlockGrass) {
            this.type = StateContainer.WellKnownBlockClasses.GRASS;
        } else if (blk instanceof BlockLiquid) {
            this.type = StateContainer.WellKnownBlockClasses.LIQUID;
        }
    }
}

