/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.statehandlers;

import java.util.List;
import org.dynmap.blockscan.statehandlers.IStateHandler;
import org.dynmap.blockscan.statehandlers.StateContainer;

public interface IStateHandlerFactory {
    public static final String[] booleanValues = new String[]{"true", "false"};
    public static final String[] stairShapeValues = new String[]{"straight", "inner_left", "inner_right", "outer_left", "outer_right"};
    public static final String[] facingValues = new String[]{"north", "south", "east", "west"};

    public IStateHandler canHandleBlockState(StateContainer var1);

    public static boolean findMatchingProperty(StateContainer bsc, String prop, String[] values) {
        List<String> vals = bsc.renderProperties.get(prop);
        if (vals == null) {
            return false;
        }
        if (values.length != vals.size()) {
            return false;
        }
        int cnt = 0;
        for (String v : vals) {
            boolean match = false;
            for (String mval : values) {
                if (!mval.equals(v)) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
            ++cnt;
        }
        return cnt == values.length;
    }

    public static boolean findMatchingBooleanProperty(StateContainer bsc, String prop) {
        return IStateHandlerFactory.findMatchingProperty(bsc, prop, booleanValues);
    }
}

