/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.statehandlers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dynmap.blockscan.statehandlers.IStateHandler;
import org.dynmap.blockscan.statehandlers.IStateHandlerFactory;
import org.dynmap.blockscan.statehandlers.StateContainer;

public class NSEWUConnectedMetadataStateHandler
implements IStateHandlerFactory {
    private static final int CONNECTCNT = 32;
    private static final int UP_OFF = 1;
    private static final int NORTH_OFF = 2;
    private static final int SOUTH_OFF = 4;
    private static final int EAST_OFF = 8;
    private static final int WEST_OFF = 16;

    @Override
    public IStateHandler canHandleBlockState(StateContainer bsc) {
        boolean up = IStateHandlerFactory.findMatchingBooleanProperty(bsc, "up");
        boolean north = IStateHandlerFactory.findMatchingBooleanProperty(bsc, "north");
        boolean south = IStateHandlerFactory.findMatchingBooleanProperty(bsc, "south");
        boolean east = IStateHandlerFactory.findMatchingBooleanProperty(bsc, "east");
        boolean west = IStateHandlerFactory.findMatchingBooleanProperty(bsc, "west");
        if (!(up && north && south && east && west)) {
            return null;
        }
        List<StateContainer.StateRec> state = bsc.getValidStates();
        StateContainer.StateRec[][] metavalues = new StateContainer.StateRec[16][];
        for (int i = 0; i < 16; ++i) {
            metavalues[i] = new StateContainer.StateRec[32];
        }
        for (StateContainer.StateRec s : state) {
            int index = NSEWUConnectedMetadataStateHandler.getBoolIndex(s.getValue("up"), 1);
            index += NSEWUConnectedMetadataStateHandler.getBoolIndex(s.getValue("north"), 2);
            index += NSEWUConnectedMetadataStateHandler.getBoolIndex(s.getValue("south"), 4);
            index += NSEWUConnectedMetadataStateHandler.getBoolIndex(s.getValue("east"), 8);
            index += NSEWUConnectedMetadataStateHandler.getBoolIndex(s.getValue("west"), 16);
            for (int meta : s.metadata) {
                if (meta < 0 || meta > 15) {
                    return null;
                }
                if (metavalues[meta][index] != null) {
                    return null;
                }
                metavalues[meta][index] = s;
            }
        }
        for (int i = 0; i < metavalues.length; ++i) {
            for (int j = 0; j < 32; ++j) {
                if (metavalues[i][j] != null) continue;
                metavalues[i][j] = bsc.getDefaultState();
            }
        }
        return new OurHandler(metavalues);
    }

    private static final int getBoolIndex(String v, int off) {
        return v.equals("true") ? off : 0;
    }

    class OurHandler
    implements IStateHandler {
        private String[] string_values = new String[512];
        private Map<String, String>[] map_values = new Map[512];

        OurHandler(StateContainer.StateRec[][] states) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 32; ++j) {
                    StateContainer.StateRec bs = states[i][j];
                    HashMap<String, String> m = new HashMap<String, String>();
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, String> p : bs.getProperties().entrySet()) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(p.getKey()).append("=").append(p.getValue());
                        m.put(p.getKey(), p.getValue());
                    }
                    this.map_values[16 * j + i] = m;
                    this.string_values[16 * j + i] = sb.toString();
                }
            }
        }

        @Override
        public String getName() {
            return "NSEWUConnectedMetadataState";
        }

        @Override
        public int getBlockStateIndex(int blockid, int blockmeta) {
            return blockmeta;
        }

        @Override
        public Map<String, String>[] getBlockStateValueMaps() {
            return this.map_values;
        }

        @Override
        public String[] getBlockStateValues() {
            return this.string_values;
        }
    }
}

