/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.statehandlers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dynmap.blockscan.statehandlers.IStateHandler;
import org.dynmap.blockscan.statehandlers.IStateHandlerFactory;
import org.dynmap.blockscan.statehandlers.StateContainer;

public class PistonMetadataStateHandler
implements IStateHandlerFactory {
    @Override
    public IStateHandler canHandleBlockState(StateContainer bsc) {
        boolean shortp = IStateHandlerFactory.findMatchingBooleanProperty(bsc, "short");
        if (!shortp) {
            return null;
        }
        List<StateContainer.StateRec> state = bsc.getValidStates();
        if (state.size() > 32) {
            return null;
        }
        StateContainer.StateRec[] metavalues = new StateContainer.StateRec[16];
        StateContainer.StateRec[] shortpmetavalues = new StateContainer.StateRec[16];
        for (StateContainer.StateRec s : state) {
            String is_shortp = s.getValue("short");
            for (int meta : s.metadata) {
                if (meta < 0 || meta > 15) {
                    return null;
                }
                if (is_shortp.equals("false")) {
                    if (metavalues[meta] != null) {
                        return null;
                    }
                    metavalues[meta] = s;
                    continue;
                }
                if (shortpmetavalues[meta] != null) {
                    return null;
                }
                shortpmetavalues[meta] = s;
            }
        }
        for (int i = 0; i < metavalues.length; ++i) {
            if (metavalues[i] == null) {
                metavalues[i] = bsc.getDefaultState();
            }
            if (shortpmetavalues[i] != null) continue;
            shortpmetavalues[i] = bsc.getDefaultState();
        }
        return new OurHandler(metavalues, shortpmetavalues);
    }

    class OurHandler
    implements IStateHandler {
        private String[] string_values = new String[32];
        private Map<String, String>[] map_values = new Map[32];

        OurHandler(StateContainer.StateRec[] states, StateContainer.StateRec[] shortpstates) {
            StringBuilder sb;
            HashMap<String, String> m;
            StateContainer.StateRec bs;
            int i;
            for (i = 0; i < 16; ++i) {
                bs = shortpstates[i];
                m = new HashMap<String, String>();
                sb = new StringBuilder();
                for (Map.Entry<String, String> p : bs.getProperties().entrySet()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(p.getKey()).append("=").append(p.getValue());
                    m.put(p.getKey(), p.getValue());
                }
                this.map_values[i] = m;
                this.string_values[i] = sb.toString();
            }
            for (i = 0; i < 16; ++i) {
                bs = states[i];
                m = new HashMap();
                sb = new StringBuilder();
                for (Map.Entry<String, String> p : bs.getProperties().entrySet()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(p.getKey()).append("=").append(p.getValue());
                    m.put(p.getKey(), p.getValue());
                }
                this.map_values[16 + i] = m;
                this.string_values[16 + i] = sb.toString();
            }
        }

        @Override
        public String getName() {
            return "PistonMetadataState";
        }

        @Override
        public int getBlockStateIndex(int blockid, int blockmeta) {
            return blockmeta;
        }

        @Override
        public Map<String, String>[] getBlockStateValueMaps() {
            return this.map_values;
        }

        @Override
        public String[] getBlockStateValues() {
            return this.string_values;
        }
    }
}

