/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.statehandlers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dynmap.blockscan.statehandlers.IStateHandler;
import org.dynmap.blockscan.statehandlers.IStateHandlerFactory;
import org.dynmap.blockscan.statehandlers.StateContainer;

public class RedstoneWireStateHandler
implements IStateHandlerFactory {
    private static final String[] POWER = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};
    private static final String[] SIDE = new String[]{"none", "side", "up"};
    private static final int STATECNT = POWER.length * SIDE.length * SIDE.length * SIDE.length * SIDE.length;
    private static final int POWER_OFF = SIDE.length * SIDE.length * SIDE.length * SIDE.length;
    private static final int NORTH_OFF = SIDE.length * SIDE.length * SIDE.length;
    private static final int SOUTH_OFF = SIDE.length * SIDE.length;
    private static final int EAST_OFF = SIDE.length;
    private static final int WEST_OFF = 1;

    @Override
    public IStateHandler canHandleBlockState(StateContainer bsc) {
        boolean power = IStateHandlerFactory.findMatchingProperty(bsc, "power", POWER);
        if (!power) {
            return null;
        }
        boolean north = IStateHandlerFactory.findMatchingProperty(bsc, "north", SIDE);
        boolean south = IStateHandlerFactory.findMatchingProperty(bsc, "south", SIDE);
        boolean east = IStateHandlerFactory.findMatchingProperty(bsc, "east", SIDE);
        boolean west = IStateHandlerFactory.findMatchingProperty(bsc, "west", SIDE);
        if (!(north && south && east && west)) {
            return null;
        }
        List<StateContainer.StateRec> state = bsc.getValidStates();
        if (state.size() != STATECNT) {
            return null;
        }
        StateContainer.StateRec[] metavalues = new StateContainer.StateRec[STATECNT];
        for (StateContainer.StateRec s : state) {
            int index = Integer.parseInt(s.getValue("power")) * POWER_OFF;
            index += RedstoneWireStateHandler.getSideIndex(s.getValue("north")) * NORTH_OFF;
            index += RedstoneWireStateHandler.getSideIndex(s.getValue("south")) * SOUTH_OFF;
            index += RedstoneWireStateHandler.getSideIndex(s.getValue("east")) * EAST_OFF;
            metavalues[index += RedstoneWireStateHandler.getSideIndex((String)s.getValue((String)"west")) * 1] = s;
        }
        return new OurHandler(metavalues);
    }

    private static final int getSideIndex(String value) {
        for (int i = 0; i < SIDE.length; ++i) {
            if (!SIDE[i].equals(value)) continue;
            return i;
        }
        return 0;
    }

    class OurHandler
    implements IStateHandler {
        private String[] string_values = new String[RedstoneWireStateHandler.access$000()];
        private Map<String, String>[] map_values = new Map[RedstoneWireStateHandler.access$000()];

        OurHandler(StateContainer.StateRec[] states) {
            for (int i = 0; i < STATECNT; ++i) {
                StateContainer.StateRec bs = states[i];
                HashMap<String, String> m = new HashMap<String, String>();
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, String> p : bs.getProperties().entrySet()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(p.getKey()).append("=").append(p.getValue());
                    m.put(p.getKey(), p.getValue());
                }
                this.map_values[i] = m;
                this.string_values[i] = sb.toString();
            }
        }

        @Override
        public String getName() {
            return "RedstoneWireMetadataState";
        }

        @Override
        public int getBlockStateIndex(int blockid, int blockmeta) {
            return blockmeta * POWER_OFF;
        }

        @Override
        public Map<String, String>[] getBlockStateValueMaps() {
            return this.map_values;
        }

        @Override
        public String[] getBlockStateValues() {
            return this.string_values;
        }
    }
}

