/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.statehandlers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dynmap.blockscan.statehandlers.IStateHandler;
import org.dynmap.blockscan.statehandlers.IStateHandlerFactory;
import org.dynmap.blockscan.statehandlers.StateContainer;

public class SimpleMetadataStateHandler
implements IStateHandlerFactory {
    private boolean strict;

    public SimpleMetadataStateHandler(boolean isStrict) {
        this.strict = isStrict;
    }

    @Override
    public IStateHandler canHandleBlockState(StateContainer bsc) {
        List<StateContainer.StateRec> state = bsc.getValidStates();
        if (this.strict && state.size() > 16) {
            return null;
        }
        StateContainer.StateRec[] metavalues = new StateContainer.StateRec[16];
        for (StateContainer.StateRec s : state) {
            for (int meta : s.metadata) {
                if (meta < 0 || meta > 15 || metavalues[meta] != null) {
                    if (!this.strict) continue;
                    return null;
                }
                metavalues[meta] = s;
            }
        }
        for (int i = 0; i < metavalues.length; ++i) {
            if (metavalues[i] != null) continue;
            metavalues[i] = bsc.getDefaultState();
        }
        return new OurHandler(metavalues);
    }

    class OurHandler
    implements IStateHandler {
        private String[] string_values = new String[16];
        private Map<String, String>[] map_values = new Map[16];

        OurHandler(StateContainer.StateRec[] states) {
            for (int i = 0; i < 16; ++i) {
                StateContainer.StateRec bs = states[i];
                HashMap<String, String> m = new HashMap<String, String>();
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, String> p : bs.getProperties().entrySet()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(p.getKey()).append("=").append(p.getValue());
                    m.put(p.getKey(), p.getValue());
                }
                this.map_values[i] = m;
                this.string_values[i] = sb.toString();
            }
        }

        @Override
        public String getName() {
            if (SimpleMetadataStateHandler.this.strict) {
                return "SimpleMetadataState";
            }
            return "DefaultMetadataState";
        }

        @Override
        public int getBlockStateIndex(int blockid, int blockmeta) {
            return blockmeta;
        }

        @Override
        public Map<String, String>[] getBlockStateValueMaps() {
            return this.map_values;
        }

        @Override
        public String[] getBlockStateValues() {
            return this.string_values;
        }
    }
}

