/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.statehandlers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dynmap.blockscan.statehandlers.IStateHandler;
import org.dynmap.blockscan.statehandlers.IStateHandlerFactory;
import org.dynmap.blockscan.statehandlers.StateContainer;

public class StairMetadataStateHandler
implements IStateHandlerFactory {
    private static final String[] SHAPES = IStateHandlerFactory.stairShapeValues;

    @Override
    public IStateHandler canHandleBlockState(StateContainer bsc) {
        boolean shape = IStateHandlerFactory.findMatchingProperty(bsc, "shape", SHAPES);
        if (!shape) {
            return null;
        }
        if (bsc.getProperty("facing") == null || bsc.getProperty("half") == null) {
            return null;
        }
        List<StateContainer.StateRec> state = bsc.getValidStates();
        StateContainer.StateRec[][] metavalues = new StateContainer.StateRec[16][];
        for (int i = 0; i < 16; ++i) {
            metavalues[i] = new StateContainer.StateRec[SHAPES.length];
        }
        for (StateContainer.StateRec s : state) {
            int shapeval = StairMetadataStateHandler.getShapeIndex(s.getValue("shape"));
            for (int meta : s.metadata) {
                if (meta < 0 || meta > 15) {
                    return null;
                }
                if (metavalues[meta][shapeval] != null) {
                    return null;
                }
                metavalues[meta][shapeval] = s;
            }
        }
        for (int i = 0; i < metavalues.length; ++i) {
            for (int j = 0; j < SHAPES.length; ++j) {
                if (metavalues[i][j] != null) continue;
                metavalues[i][j] = bsc.getDefaultState();
            }
        }
        return new OurHandler(metavalues);
    }

    private static final int getShapeIndex(String v) {
        for (int i = 0; i < SHAPES.length; ++i) {
            if (!SHAPES[i].equals(v)) continue;
            return i;
        }
        return 0;
    }

    class OurHandler
    implements IStateHandler {
        private String[] string_values = new String[16 * StairMetadataStateHandler.access$000().length];
        private Map<String, String>[] map_values = new Map[16 * StairMetadataStateHandler.access$000().length];

        OurHandler(StateContainer.StateRec[][] states) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < SHAPES.length; ++j) {
                    StateContainer.StateRec bs = states[i][j];
                    HashMap<String, String> m = new HashMap<String, String>();
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, String> p : bs.getProperties().entrySet()) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(p.getKey()).append("=").append(p.getValue());
                        m.put(p.getKey(), p.getValue());
                    }
                    this.map_values[16 * j + i] = m;
                    this.string_values[16 * j + i] = sb.toString();
                }
            }
        }

        @Override
        public String getName() {
            return "StairMetadataState";
        }

        @Override
        public int getBlockStateIndex(int blockid, int blockmeta) {
            return blockmeta;
        }

        @Override
        public Map<String, String>[] getBlockStateValueMaps() {
            return this.map_values;
        }

        @Override
        public String[] getBlockStateValues() {
            return this.string_values;
        }
    }
}

