/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.statehandlers;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StateContainer {
    protected Map<String, List<String>> renderProperties = new HashMap<String, List<String>>();
    protected final List<StateRec> records = new ArrayList<StateRec>();
    protected int defStateIndex;
    protected WellKnownBlockClasses type = WellKnownBlockClasses.NONE;

    public List<StateRec> getValidStates() {
        return this.records;
    }

    public StateRec getDefaultState() {
        return this.records.get(this.defStateIndex);
    }

    public Set<String> getProperties() {
        return this.renderProperties.keySet();
    }

    public List<String> getProperty(String prop) {
        return this.renderProperties.get(prop);
    }

    public WellKnownBlockClasses getBlockType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ properties=").append(this.renderProperties).append(", records=").append(this.records).append(",defStateindex=").append(this.defStateIndex).append("}");
        return sb.toString();
    }

    public static enum WellKnownBlockClasses {
        NONE,
        LEAVES,
        CROPS,
        FLOWER,
        TALLGRASS,
        BUSH,
        GRASS,
        LIQUID,
        VINES;

    }

    public static class StateRec {
        public final ImmutableMap<String, String> keyValuePairs;
        public final int[] metadata;

        public StateRec(int meta, ImmutableMap<String, String> kvp) {
            this.keyValuePairs = kvp;
            this.metadata = new int[]{meta};
        }

        public StateRec(StateRec prev, int new_meta) {
            this.keyValuePairs = prev.keyValuePairs;
            int[] newmeta = new int[prev.metadata.length + 1];
            System.arraycopy(prev.metadata, 0, newmeta, 0, prev.metadata.length);
            newmeta[prev.metadata.length] = new_meta;
            this.metadata = newmeta;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof StateRec) {
                StateRec sr = (StateRec)obj;
                return sr.keyValuePairs.equals(this.keyValuePairs);
            }
            return false;
        }

        public boolean hasMeta(int meta) {
            for (int i = 0; i < this.metadata.length; ++i) {
                if (this.metadata[i] != meta) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.keyValuePairs.hashCode();
        }

        public String getValue(String prop) {
            return (String)this.keyValuePairs.get((Object)prop);
        }

        public Map<String, String> getProperties() {
            return this.keyValuePairs;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ values=").append(this.keyValuePairs).append(",meta=").append(Arrays.toString(this.metadata)).append("}");
            return sb.toString();
        }
    }
}

