/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.blockscan.util;

public class Vector3D {
    public double x;
    public double y;
    public double z;

    public Vector3D() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D(Vector3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public final void set(Vector3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public final void subtract(Vector3D v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public final void add(Vector3D v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public final void scale(double s) {
        this.x = s * this.x;
        this.y = s * this.y;
        this.z = s * this.z;
    }

    public final void scale(Vector3D v) {
        this.x = v.x * this.x;
        this.y = v.y * this.y;
        this.z = v.z * this.z;
    }

    public final double innerProduct(Vector3D v) {
        return v.x * this.x + v.y * this.y + v.z * this.z;
    }

    public final void crossProduct(Vector3D v) {
        double newx = this.y * v.z - this.z * v.y;
        double newy = this.z * v.x - this.x * v.z;
        double newz = this.x * v.y - this.y * v.x;
        this.x = newx;
        this.y = newy;
        this.z = newz;
    }

    public String toString() {
        return "{ " + this.x + ", " + this.y + ", " + this.z + " }";
    }

    public boolean equals(Object v) {
        if (v instanceof Vector3D) {
            Vector3D vv = (Vector3D)v;
            return vv.x == this.x && vv.y == this.y && vv.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.z);
        return (int)(v ^ v >> 32);
    }
}

