/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.renderer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class DynmapBlockState {
    public final int stateIndex;
    public final DynmapBlockState baseState;
    public final String blockName;
    public final String stateName;
    public final int globalStateIndex = nextGlobalStateIndex++;
    public final int legacyBlockID;
    private DynmapBlockState[] states;
    private final String fullName;
    public final String material;
    private static int nextGlobalStateIndex = 0;
    private int matchflags;
    private static int MATCH_AIR = 1;
    private static int MATCH_WATER = 2;
    private static int MATCH_SNOW = 4;
    private static int MATCH_LOG = 8;
    private static int MATCH_GRASS = 16;
    private static int MATCH_WATERLOGGED = 32;
    private static int MATCH_LEAVES = 64;
    private static int MATCH_SOLID = 128;
    private static HashMap<String, DynmapBlockState> blocksByName = new HashMap();
    private static HashMap<Integer, DynmapBlockState> blocksByIndex = new HashMap();
    private static HashMap<Integer, DynmapBlockState> blocksByLegacyID = new HashMap();
    public static String AIR_BLOCK = "minecraft:air";
    public static String STONE_BLOCK = "minecraft:stone";
    public static String GRASS_BLOCK = "minecraft:grass";
    public static String GOLD_ORE_BLOCK = "minecraft:gold_ore";
    public static String IRON_ORE_BLOCK = "minecraft:iron_ore";
    public static String COAL_ORE_BLOCK = "minecraft:coal_ore";
    public static String LAPIS_ORE_BLOCK = "minecraft:lapis_ore";
    public static String DIAMOND_ORE_BLOCK = "minecraft:diamond_ore";
    public static String REDSTONE_ORE_BLOCK = "minecraft:redstone_ore";
    public static String LIT_REDSTONE_ORE_BLOCK = "minecraft:lit_redstone_ore";
    public static String EMERALD_ORE_BLOCK = "minecraft:emerald_ore";
    public static String QUARTZ_ORE_BLOCK = "minecraft:quartz_ore";
    public static String LOG_BLOCK = "minecraft:log";
    public static String LOG2_BLOCK = "minecraft:log2";
    public static String LEAVES_BLOCK = "minecraft:leaves";
    public static String LEAVES2_BLOCK = "minecraft:leaves2";
    public static String GLASS_BLOCK = "minecraft:glass";
    public static String WOODEN_DOOR_BLOCK = "minecraft:wooden_door";
    public static String IRON_DOOR_BLOCK = "minecraft:iron_door";
    public static String SNOW_LAYER_BLOCK = "minecraft:snow_layer";
    public static String SNOW_BLOCK = "minecraft:snow";
    public static String ICE_BLOCK = "minecraft:ice";
    public static String QUARTZ_BLOCK = "minecraft:quartz_block";
    public static String WATER_BLOCK = "minecraft:water";
    public static String FLOWING_WATER_BLOCK = "minecraft:flowing_water";
    private static HashSet<String> log_blocks = new HashSet<String>(Arrays.asList(LOG_BLOCK, LOG2_BLOCK));
    private static HashSet<String> water_blocks = new HashSet<String>(Arrays.asList(WATER_BLOCK, FLOWING_WATER_BLOCK));
    public static final DynmapBlockState AIR = new DynmapBlockState(null, 0, AIR_BLOCK, "", "AIR", 0);
    private static DynmapBlockState still_water = null;

    public DynmapBlockState(DynmapBlockState base, int stateidx, String blkname, String statename, String material) {
        this(base, stateidx, blkname, statename, material, -1);
    }

    public DynmapBlockState(DynmapBlockState base, int stateidx, String blkname, String statename, String material, int legacyblkid) {
        if (base == null) {
            base = this;
        }
        this.baseState = base;
        this.stateIndex = stateidx;
        this.legacyBlockID = legacyblkid;
        this.material = material;
        if (blkname.indexOf(58) == -1) {
            blkname = "minecraft:" + blkname;
        }
        this.blockName = blkname;
        String string = this.stateName = statename != null ? statename : "";
        if (base != this) {
            if (base.states == null) {
                base.states = new DynmapBlockState[stateidx + 1];
                Arrays.fill(base.states, AIR);
                base.states[0] = base;
            } else if (base.states.length <= stateidx) {
                Object[] newstates = new DynmapBlockState[stateidx + 1];
                System.arraycopy(base.states, 0, newstates, 0, base.states.length);
                Arrays.fill(newstates, base.states.length, stateidx + 1, AIR);
                base.states = newstates;
            }
            base.states[stateidx] = this;
        }
        if (base == this) {
            blocksByName.put(blkname, this);
            if (this.legacyBlockID >= 0) {
                blocksByLegacyID.put(this.legacyBlockID, this);
            }
        }
        this.fullName = this.stateName.length() > 0 ? this.blockName + "[" + this.stateName + "]" : this.blockName;
        blocksByIndex.put(this.globalStateIndex, this);
        this.matchflags |= this.blockName.equals(AIR_BLOCK) ? MATCH_AIR : 0;
        this.matchflags |= DynmapBlockState.isWater(this.blockName) ? MATCH_WATER : 0;
        this.matchflags |= this.blockName.equals(SNOW_BLOCK) || this.blockName.equals(SNOW_LAYER_BLOCK) ? MATCH_SNOW : 0;
        this.matchflags |= this.blockName.equals(GRASS_BLOCK) ? MATCH_GRASS : 0;
        this.matchflags |= log_blocks.contains(this.blockName) ? MATCH_LOG : 0;
        if (this.blockName.equals(WATER_BLOCK) && this == this.baseState) {
            still_water = this;
        }
    }

    public final DynmapBlockState getStateByIndex(int idx) {
        if (this.baseState.states == null) {
            return idx == 0 ? this : null;
        }
        return idx >= 0 && idx < this.baseState.states.length ? this.baseState.states[idx] : AIR;
    }

    public static final DynmapBlockState getBaseStateByName(String name) {
        DynmapBlockState blk = blocksByName.get(name);
        if (blk == null && name.indexOf(58) == -1) {
            blk = blocksByName.get("minecraft:" + name);
        }
        return blk != null ? blk : AIR;
    }

    public static final DynmapBlockState getStateByNameAndIndex(String name, int idx) {
        DynmapBlockState blk = DynmapBlockState.getBaseStateByName(name);
        if (blk != null) {
            blk = blk.getState(idx);
        }
        return blk != null ? blk : AIR;
    }

    public static final DynmapBlockState getStateByGlobalIndex(int gidx) {
        DynmapBlockState bs = blocksByIndex.get(gidx);
        return bs != null ? bs : AIR;
    }

    public static final DynmapBlockState getStateByLegacyBlockID(int legacyid) {
        return blocksByLegacyID.get(legacyid);
    }

    public static final DynmapBlockState getStateByNameAndState(String name, String statename) {
        DynmapBlockState blk = DynmapBlockState.getBaseStateByName(name);
        if (blk != null) {
            if (blk.states != null) {
                for (DynmapBlockState bb : blk.states) {
                    if (!bb.stateName.contains(statename)) continue;
                    return bb;
                }
            }
            blk = null;
        }
        return blk != null ? blk : AIR;
    }

    public static final int getGlobalIndexMax() {
        return nextGlobalStateIndex;
    }

    public final boolean isNotAir() {
        return (this.matchflags & MATCH_AIR) == 0;
    }

    public final boolean isAir() {
        return (this.matchflags & MATCH_AIR) != 0;
    }

    public final void setAir() {
        this.matchflags |= MATCH_AIR;
    }

    public final int getStateCount() {
        if (this.baseState.states == null) {
            return 1;
        }
        return this.baseState.states.length;
    }

    public final DynmapBlockState getState(int idx) {
        if (this.baseState.states == null) {
            return idx == 0 ? this : AIR;
        }
        return idx < this.baseState.states.length ? this.baseState.states[idx] : AIR;
    }

    public final boolean isLog() {
        return (this.matchflags & MATCH_LOG) != 0;
    }

    public final void setLog() {
        this.matchflags |= MATCH_LOG;
    }

    public final boolean isWater() {
        return (this.matchflags & MATCH_WATER) != 0;
    }

    public static boolean isWater(String blockname) {
        return water_blocks.contains(blockname);
    }

    public void addWaterBlock(String name) {
        water_blocks.add(name);
        DynmapBlockState bbs = DynmapBlockState.getBaseStateByName(name);
        if (bbs.isNotAir()) {
            for (int i = 0; i < bbs.getStateCount(); ++i) {
                bbs.states[i].matchflags |= MATCH_WATER;
            }
        }
    }

    public final boolean isSnow() {
        return (this.matchflags & MATCH_SNOW) != 0;
    }

    public final boolean isGrass() {
        return (this.matchflags & MATCH_GRASS) != 0;
    }

    public final boolean isWaterlogged() {
        return (this.matchflags & MATCH_WATERLOGGED) != 0;
    }

    public final void setWaterlogged() {
        this.matchflags |= MATCH_WATERLOGGED;
    }

    public final boolean isWaterFilled() {
        return (this.matchflags & (MATCH_WATERLOGGED | MATCH_WATER)) != 0;
    }

    public final boolean isLeaves() {
        return (this.matchflags & MATCH_LEAVES) != 0;
    }

    public final void setLeaves() {
        this.matchflags |= MATCH_LEAVES;
    }

    public boolean is(String blkname) {
        return this.blockName.equals(blkname);
    }

    public boolean matchingBaseState(DynmapBlockState blk) {
        return this.baseState == blk.baseState;
    }

    public DynmapBlockState getLiquidState() {
        if (this.isWaterlogged()) {
            return still_water;
        }
        return null;
    }

    public boolean isSolid() {
        return (this.matchflags & MATCH_SOLID) != 0;
    }

    public void setSolid() {
        this.matchflags |= MATCH_SOLID;
    }

    public String toString() {
        return this.fullName;
    }
}

