/*
 * Decompiled with CFR 0.152.
 */
package openmods.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import net.minecraft.item.ItemStack;
import openmods.inventory.comparator.EqualComponents;

public class StackEqualityTesterBuilder {
    private boolean usedItem;
    private boolean usedItemId;
    private boolean usedDamage;
    private boolean usedSize;
    private boolean usedNBT;
    private EqualComponents.IItemStackTester tester = null;

    private void compose(EqualComponents.IItemStackTester newTerm) {
        if (this.tester == null) {
            this.tester = newTerm;
        } else {
            EqualComponents.IItemStackTester current = this.tester;
            this.tester = (left, right) -> newTerm.isEqual(left, right) && current.isEqual(left, right);
        }
    }

    public StackEqualityTesterBuilder useItem() {
        Preconditions.checkState((!this.usedItem ? 1 : 0) != 0);
        this.usedItem = true;
        this.compose(EqualComponents.ITEM_TESTER);
        return this;
    }

    public StackEqualityTesterBuilder useItemId() {
        Preconditions.checkState((!this.usedItemId ? 1 : 0) != 0);
        this.usedItemId = true;
        this.compose(EqualComponents.ITEM_ID_TESTER);
        return this;
    }

    public StackEqualityTesterBuilder useDamage() {
        Preconditions.checkState((!this.usedDamage ? 1 : 0) != 0);
        this.usedDamage = true;
        this.compose(EqualComponents.DAMAGE_TESTER);
        return this;
    }

    public StackEqualityTesterBuilder useSize() {
        Preconditions.checkState((!this.usedSize ? 1 : 0) != 0);
        this.usedSize = true;
        this.compose(EqualComponents.SIZE_TESTER);
        return this;
    }

    public StackEqualityTesterBuilder useNBT() {
        Preconditions.checkState((!this.usedNBT ? 1 : 0) != 0);
        this.usedNBT = true;
        this.compose(EqualComponents.NBT_TESTER);
        return this;
    }

    public IEqualityTester build() {
        EqualComponents.IItemStackTester tester = this.tester != null ? this.tester : (left, right) -> true;
        return (left, right) -> {
            if (left == right) {
                return true;
            }
            if (left instanceof ItemStack && right instanceof ItemStack) {
                return tester.isEqual((ItemStack)left, (ItemStack)right);
            }
            return false;
        };
    }

    public Predicate<ItemStack> buildPredicate(ItemStack template) {
        ItemStack copy = template.func_77946_l();
        IEqualityTester tester = this.build();
        return input -> tester.isEqual(copy, input);
    }

    @FunctionalInterface
    public static interface IEqualityTester {
        public boolean isEqual(Object var1, Object var2);
    }
}

