/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.render;

import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import openmods.Log;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTFramebufferBlit;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;

public abstract class FramebufferBlitter {
    public static FramebufferBlitter INSTANCE = new FramebufferBlitter(){

        @Override
        protected void blitFramebufferOp(Framebuffer in, Framebuffer out) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int getReadConst() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int getDrawConst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isValid() {
            return false;
        }
    };

    public static boolean setup() {
        if (OpenGlHelper.field_148823_f) {
            ContextCapabilities caps = GLContext.getCapabilities();
            if (caps.OpenGL30) {
                Log.debug("Using OpenGL 3.0 FB blit", new Object[0]);
                INSTANCE = new GL30Impl();
                return true;
            }
            if (caps.GL_EXT_framebuffer_blit) {
                Log.debug("Using EXT FB blit", new Object[0]);
                INSTANCE = new ExtImpl();
                return true;
            }
        }
        Log.debug("FB blit not supported", new Object[0]);
        return false;
    }

    public void blitFramebuffer(Framebuffer in, Framebuffer out) {
        OpenGlHelper.func_153171_g((int)this.getReadConst(), (int)in.field_147616_f);
        OpenGlHelper.func_153171_g((int)this.getDrawConst(), (int)out.field_147616_f);
        this.blitFramebufferOp(in, out);
        OpenGlHelper.func_153171_g((int)this.getReadConst(), (int)0);
        OpenGlHelper.func_153171_g((int)this.getDrawConst(), (int)0);
    }

    protected abstract void blitFramebufferOp(Framebuffer var1, Framebuffer var2);

    protected abstract int getReadConst();

    protected abstract int getDrawConst();

    public abstract boolean isValid();

    private static class ExtImpl
    extends FramebufferBlitter {
        private ExtImpl() {
        }

        @Override
        public void blitFramebufferOp(Framebuffer in, Framebuffer out) {
            EXTFramebufferBlit.glBlitFramebufferEXT((int)0, (int)0, (int)in.field_147621_c, (int)in.field_147618_d, (int)0, (int)0, (int)out.field_147621_c, (int)out.field_147618_d, (int)16384, (int)9728);
        }

        @Override
        protected int getReadConst() {
            return 36008;
        }

        @Override
        protected int getDrawConst() {
            return 36009;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    private static class GL30Impl
    extends FramebufferBlitter {
        private GL30Impl() {
        }

        @Override
        public void blitFramebufferOp(Framebuffer in, Framebuffer out) {
            GL30.glBlitFramebuffer((int)0, (int)0, (int)in.field_147621_c, (int)in.field_147618_d, (int)0, (int)0, (int)out.field_147621_c, (int)out.field_147618_d, (int)16384, (int)9728);
        }

        @Override
        protected int getReadConst() {
            return 36008;
        }

        @Override
        protected int getDrawConst() {
            return 36009;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }
}

