/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.sneaky;

import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.features.DUFeature;
import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.material.FeatureMaterial;
import net.darkhax.darkutils.features.sneaky.BlockColorSneaky;
import net.darkhax.darkutils.features.sneaky.BlockSneaky;
import net.darkhax.darkutils.features.sneaky.BlockSneakyBedrock;
import net.darkhax.darkutils.features.sneaky.BlockSneakyButton;
import net.darkhax.darkutils.features.sneaky.BlockSneakyGhost;
import net.darkhax.darkutils.features.sneaky.BlockSneakyLever;
import net.darkhax.darkutils.features.sneaky.BlockSneakyPressurePlate;
import net.darkhax.darkutils.features.sneaky.BlockSneakyTorch;
import net.darkhax.darkutils.features.sneaky.ModelSneakyBlock;
import net.darkhax.darkutils.features.sneaky.TileEntitySneaky;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@DUFeature(name="Sneaky Blocks", description="Blocks that can hide as other blocks")
public class FeatureSneaky
extends Feature {
    public static Block blockSneakyBlock;
    public static Block blockSneakyLever;
    public static Block blockSneakyGhost;
    public static Block blockSneakyTorch;
    public static Block blockSneakyObsidian;
    public static Block blockSneakyPlate;
    public static Block blockSneakyBedrock;
    public static Block blockSneakyButton;
    public static boolean opacity;

    @Override
    public void onPreInit() {
        blockSneakyBlock = new BlockSneaky();
        DarkUtils.REGISTRY.registerBlock(blockSneakyBlock, "sneaky");
        GameRegistry.registerTileEntity(TileEntitySneaky.class, (String)"sneaky");
        blockSneakyLever = new BlockSneakyLever();
        DarkUtils.REGISTRY.registerBlock(blockSneakyLever, "sneaky_lever");
        blockSneakyGhost = new BlockSneakyGhost();
        DarkUtils.REGISTRY.registerBlock(blockSneakyGhost, "sneaky_ghost");
        blockSneakyTorch = new BlockSneakyTorch();
        DarkUtils.REGISTRY.registerBlock(blockSneakyTorch, "sneaky_torch");
        blockSneakyObsidian = new BlockSneaky().func_149711_c(20.0f).func_149752_b(2000.0f);
        DarkUtils.REGISTRY.registerBlock(blockSneakyObsidian, "sneaky_obsidian");
        blockSneakyPlate = new BlockSneakyPressurePlate();
        DarkUtils.REGISTRY.registerBlock(blockSneakyPlate, "sneaky_plate");
        blockSneakyBedrock = new BlockSneakyBedrock();
        DarkUtils.REGISTRY.registerBlock(blockSneakyBedrock, "sneaky_bedrock");
        blockSneakyButton = new BlockSneakyButton();
        DarkUtils.REGISTRY.registerBlock(blockSneakyButton, "sneaky_button");
    }

    @Override
    public void setupConfiguration(Configuration config) {
        opacity = config.getBoolean("Opacity", this.configName, true, "When true, all sneaky blocks will let no light through. When disabled, all light will be let through.");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientInit() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new BlockColorSneaky(), new Block[]{blockSneakyBlock, blockSneakyLever, blockSneakyGhost, blockSneakyTorch, blockSneakyObsidian, blockSneakyPlate, blockSneakyBedrock});
        this.registerSneakyModel(blockSneakyBlock, "sneaky_default");
        this.registerSneakyModel(blockSneakyLever, "sneaky_lever");
        this.registerSneakyModel(blockSneakyGhost, "sneaky_default");
        this.registerSneakyModel(blockSneakyTorch, "sneaky_torch");
        this.registerSneakyModel(blockSneakyObsidian, "sneaky_default");
        this.registerSneakyModel(blockSneakyPlate, "sneaky_plate");
        this.registerSneakyModel(blockSneakyBedrock, "sneaky_default");
        this.registerSneakyModel(blockSneakyButton, "sneaky_button");
    }

    @Override
    public void onPreRecipe() {
        DarkUtils.REGISTRY.addShapedRecipe("sneaky_block", new ItemStack(blockSneakyBlock, 8), new Object[]{"rrr", "rsr", "rrr", Character.valueOf('r'), "stone", Character.valueOf('s'), new ItemStack(FeatureMaterial.itemMaterial, 1, 2)});
        DarkUtils.REGISTRY.addShapelessRecipe("sneaky_lever", new ItemStack(blockSneakyLever), new Object[]{blockSneakyBlock, Blocks.field_150442_at});
        DarkUtils.REGISTRY.addShapelessRecipe("sneaky_ghost", new ItemStack(blockSneakyGhost), new Object[]{blockSneakyBlock, Blocks.field_150325_L});
        DarkUtils.REGISTRY.addShapelessRecipe("sneaky_torch", new ItemStack(blockSneakyTorch), new Object[]{blockSneakyBlock, Blocks.field_150478_aa});
        DarkUtils.REGISTRY.addShapelessRecipe("sneaky_obsidian", new ItemStack(blockSneakyObsidian), new Object[]{blockSneakyBlock, Blocks.field_150343_Z});
        DarkUtils.REGISTRY.addShapelessRecipe("sneaky_plate", new ItemStack(blockSneakyPlate), new Object[]{blockSneakyBlock, Blocks.field_150456_au});
        DarkUtils.REGISTRY.addShapelessRecipe("sneaky_bedrock", new ItemStack(blockSneakyBedrock), new Object[]{blockSneakyBlock, Blocks.field_150357_h});
        DarkUtils.REGISTRY.addShapelessRecipe("sneaky_button", new ItemStack(blockSneakyButton), new Object[]{blockSneakyBlock, Blocks.field_150430_aB});
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("darkutils:sneaky", "normal"), (Object)new ModelSneakyBlock());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("darkutils:sneaky_lever", "powered=true"), (Object)new ModelSneakyBlock());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("darkutils:sneaky_lever", "powered=false"), (Object)new ModelSneakyBlock());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("darkutils:sneaky_button", "powered=true"), (Object)new ModelSneakyBlock());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("darkutils:sneaky_button", "powered=false"), (Object)new ModelSneakyBlock());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("darkutils:sneaky_ghost", "normal"), (Object)new ModelSneakyBlock());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("darkutils:sneaky_torch", "normal"), (Object)new ModelSneakyBlock());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("darkutils:sneaky_obsidian", "normal"), (Object)new ModelSneakyBlock());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("darkutils:sneaky_plate", "powered=true"), (Object)new ModelSneakyBlock());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("darkutils:sneaky_plate", "powered=false"), (Object)new ModelSneakyBlock());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("darkutils:sneaky_bedrock", "normal"), (Object)new ModelSneakyBlock());
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSneakyModel(Block block, String name) {
        Item item = Item.func_150898_a((Block)block);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("darkutils:" + name, "inventory"));
    }
}

