/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.gui;

import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.data.LeaderboardValue;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiLeaderboard
extends GuiButtonListBase {
    private final List<LeaderboardValue> leaderboard;
    private int rankSize;
    private int usernameSize;
    private int valueSize;

    public GuiLeaderboard(ITextComponent c, List<LeaderboardValue> l) {
        this.setTitle(I18n.func_135052_a((String)"sidebar_button.ftbutilities.leaderboards", (Object[])new Object[0]) + " > " + c.func_150254_d());
        this.setHasSearchBox(true);
        this.leaderboard = l;
    }

    public void addButtons(Panel panel) {
        int i = 0;
        this.rankSize = 0;
        this.usernameSize = 0;
        this.valueSize = 0;
        for (LeaderboardValue value : this.leaderboard) {
            value.rank = ++i;
            panel.add((Widget)new LeaderboardEntry(panel, value));
        }
    }

    public String getFilterText(Widget widget) {
        return ((LeaderboardEntry)((LeaderboardEntry)widget)).value.username.toLowerCase();
    }

    private class LeaderboardEntry
    extends Widget {
        private final LeaderboardValue value;
        private final String rank;

        public LeaderboardEntry(Panel panel, LeaderboardValue v) {
            super(panel);
            this.value = v;
            this.rank = this.value.color + "#" + StringUtils.add0s((int)v.rank, (int)GuiLeaderboard.this.leaderboard.size());
            Theme theme = this.getGui().getTheme();
            GuiLeaderboard.this.rankSize = Math.max(GuiLeaderboard.this.rankSize, theme.getStringWidth(this.rank) + 4);
            GuiLeaderboard.this.usernameSize = Math.max(GuiLeaderboard.this.usernameSize, theme.getStringWidth(v.username) + 8);
            GuiLeaderboard.this.valueSize = Math.max(GuiLeaderboard.this.valueSize, theme.getStringWidth(this.value.value.func_150254_d()) + 8);
            this.setSize(GuiLeaderboard.this.rankSize + GuiLeaderboard.this.usernameSize + GuiLeaderboard.this.valueSize, 14);
        }

        public void addMouseOverText(List<String> list) {
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            WidgetType type = this.value.color == TextFormatting.DARK_GRAY ? WidgetType.DISABLED : WidgetType.mouseOver((boolean)this.isMouseOver());
            int textY = y + (h - theme.getFontHeight() + 1) / 2;
            theme.drawButton(x, y, GuiLeaderboard.this.rankSize, h, type);
            theme.drawString(this.rank, x + 2, textY, 2);
            theme.drawButton(x + GuiLeaderboard.this.rankSize, y, GuiLeaderboard.this.usernameSize, h, type);
            theme.drawString(this.value.color + this.value.username, x + 4 + GuiLeaderboard.this.rankSize, textY, 2);
            theme.drawButton(x + GuiLeaderboard.this.rankSize + GuiLeaderboard.this.usernameSize, y, GuiLeaderboard.this.valueSize, h, type);
            String formattedText = this.value.value.func_150254_d();
            theme.drawString(this.value.color + formattedText, x + GuiLeaderboard.this.rankSize + GuiLeaderboard.this.usernameSize + GuiLeaderboard.this.valueSize - theme.getStringWidth(formattedText) - 4, textY, 2);
        }
    }
}

