/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mod.collections;

import java.util.ArrayDeque;
import java.util.Deque;

public class PooledLongQueue {
    private static final int CACHED_QUEUE_SEGMENTS_COUNT = 4096;
    private static final int QUEUE_SEGMENT_SIZE = 1024;
    private final Pool pool;
    private Segment cur;
    private Segment last;
    private int size = 0;
    private volatile boolean empty;

    public PooledLongQueue(Pool pool) {
        this.pool = pool;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void add(long val) {
        if (this.cur == null) {
            this.empty = false;
            this.cur = this.last = this.pool.acquire();
        }
        if (this.last.index == 1024) {
            Segment ret = this.last.next = this.last.pool.acquire();
            ((Segment)ret).longArray[((Segment)ret).index++] = val;
            this.last = ret;
        } else {
            ((Segment)this.last).longArray[((Segment)this.last).index++] = val;
        }
        ++this.size;
    }

    public LongQueueIterator iterator() {
        return new LongQueueIterator(this.cur);
    }

    private void clear() {
        Segment segment = this.cur;
        while (segment != null) {
            Segment next = segment.next;
            segment.release();
            segment = next;
        }
        this.size = 0;
        this.cur = null;
        this.last = null;
        this.empty = true;
    }

    private static class Segment {
        private final long[] longArray = new long[1024];
        private int index = 0;
        private Segment next;
        private final Pool pool;

        private Segment(Pool pool) {
            this.pool = pool;
        }

        private void release() {
            this.index = 0;
            this.next = null;
            this.pool.release(this);
        }
    }

    public static class Pool {
        private final Deque<Segment> segmentPool = new ArrayDeque<Segment>();

        private Segment acquire() {
            if (this.segmentPool.isEmpty()) {
                return new Segment(this);
            }
            return this.segmentPool.pop();
        }

        private void release(Segment segment) {
            if (this.segmentPool.size() < 4096) {
                this.segmentPool.push(segment);
            }
        }
    }

    public class LongQueueIterator {
        private Segment cur;
        private long[] curArray;
        private int index;
        private int capacity;

        private LongQueueIterator(Segment cur) {
            this.cur = cur;
            if (this.cur != null) {
                this.curArray = cur.longArray;
                this.capacity = cur.index;
            }
        }

        public boolean hasNext() {
            return this.cur != null;
        }

        public long next() {
            long ret = this.curArray[this.index++];
            if (this.index == this.capacity) {
                this.index = 0;
                this.cur = this.cur.next;
                if (this.cur != null) {
                    this.curArray = this.cur.longArray;
                    this.capacity = this.cur.index;
                }
            }
            return ret;
        }

        public void finish() {
            PooledLongQueue.this.clear();
        }
    }
}

