/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.itemsearch;

import at.feldim2425.moreoverlays.api.itemsearch.SlotHandler;
import at.feldim2425.moreoverlays.api.itemsearch.SlotViewWrapper;
import at.feldim2425.moreoverlays.itemsearch.GuiUtils;
import at.feldim2425.moreoverlays.itemsearch.ItemUtils;
import at.feldim2425.moreoverlays.itemsearch.JeiModule;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.util.vector.Vector2f;

public class GuiRenderer {
    public static final GuiRenderer INSTANCE = new GuiRenderer();
    private static final float OVERLAY_ZLEVEL = 299.0f;
    private static final float FRAME_RADIUS = 1.0f;
    private static boolean enabled = false;
    private static String lastFilterText = "";
    private static boolean emptyFilter = true;
    private static BiMap<Slot, SlotViewWrapper> views = HashBiMap.create();
    private boolean allowRender = false;
    private int guiOffsetX = 0;
    private int guiOffsetY = 0;

    public void guiInit(GuiScreen gui) {
        if (!this.canShowIn(gui)) {
            return;
        }
        this.guiOffsetX = GuiUtils.getGuiLeft((GuiContainer)gui);
        this.guiOffsetY = GuiUtils.getGuiTop((GuiContainer)gui);
    }

    public void guiOpen(GuiScreen gui) {
    }

    public void preDraw() {
        GuiScreen guiscr = Minecraft.func_71410_x().field_71462_r;
        GuiTextField textField = JeiModule.getJEITextField();
        if (this.canShowIn(guiscr)) {
            this.allowRender = true;
            if (textField != null && enabled) {
                this.drawSearchFrame(textField);
            }
        }
    }

    public void postDraw() {
        GuiScreen guiscr = Minecraft.func_71410_x().field_71462_r;
        if (this.allowRender && this.canShowIn(guiscr)) {
            this.allowRender = false;
            this.drawSlotOverlay((GuiContainer)guiscr);
        }
    }

    private void drawSearchFrame(GuiTextField textField) {
        RenderHelper.func_74518_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179126_j();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        float x = textField.field_146209_f + 2;
        float y = textField.field_146210_g + 2;
        float width = textField.field_146218_h - 4;
        float height = textField.field_146219_i - 4;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b((double)(x + width + 1.0f), (double)(y - 1.0f), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(x - 1.0f), (double)(y - 1.0f), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(x - 1.0f), (double)y, 1000.0).func_181675_d();
        buffer.func_181662_b((double)(x + width + 1.0f), (double)y, 1000.0).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 1000.0).func_181675_d();
        buffer.func_181662_b((double)(x - 1.0f), (double)y, 1000.0).func_181675_d();
        buffer.func_181662_b((double)(x - 1.0f), (double)(y + height), 1000.0).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(x + width + 1.0f), (double)(y + height), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(x - 1.0f), (double)(y + height), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(x - 1.0f), (double)(y + height + 1.0f), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(x + width + 1.0f), (double)(y + height + 1.0f), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(x + width + 1.0f), (double)y, 1000.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, 1000.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(x + width + 1.0f), (double)(y + height), 1000.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
    }

    public void renderTooltip(ItemStack stack) {
        GuiContainer gui;
        GuiScreen guiscr = Minecraft.func_71410_x().field_71462_r;
        if (this.allowRender && this.canShowIn(guiscr) && (gui = (GuiContainer)guiscr).getSlotUnderMouse() != null && gui.getSlotUnderMouse().func_75216_d() && gui.getSlotUnderMouse().func_75211_c().equals(stack)) {
            this.allowRender = false;
            this.drawSlotOverlay((GuiContainer)guiscr);
        }
    }

    private void drawSlotOverlay(GuiContainer gui) {
        RenderHelper.func_74518_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!enabled || views == null || views.isEmpty()) {
            return;
        }
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder renderer = tess.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (Map.Entry slot : views.entrySet()) {
            if (!((SlotViewWrapper)slot.getValue()).isEnableOverlay()) continue;
            Vector2f posvec = ((SlotViewWrapper)slot.getValue()).getView().getRenderPos(this.guiOffsetX, this.guiOffsetY);
            float px = posvec.x;
            float py = posvec.y;
            renderer.func_181662_b((double)(px + 16.0f + (float)this.guiOffsetX), (double)(py + (float)this.guiOffsetY), 299.0).func_181675_d();
            renderer.func_181662_b((double)(px + (float)this.guiOffsetX), (double)(py + (float)this.guiOffsetY), 299.0).func_181675_d();
            renderer.func_181662_b((double)(px + (float)this.guiOffsetX), (double)(py + 16.0f + (float)this.guiOffsetY), 299.0).func_181675_d();
            renderer.func_181662_b((double)(px + 16.0f + (float)this.guiOffsetX), (double)(py + 16.0f + (float)this.guiOffsetY), 299.0).func_181675_d();
        }
        tess.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    public boolean canShowIn(GuiScreen gui) {
        return gui instanceof GuiContainer && ((GuiContainer)gui).field_147002_h != null && !((GuiContainer)gui).field_147002_h.field_75151_b.isEmpty();
    }

    private void checkSlots(GuiContainer container) {
        if (views == null) {
            views = HashBiMap.create();
        } else {
            views.clear();
        }
        for (Slot slot : container.field_147002_h.field_75151_b) {
            SlotViewWrapper wrapper;
            if (!views.containsKey((Object)slot)) {
                wrapper = new SlotViewWrapper(SlotHandler.INSTANCE.getViewSlot(container, slot));
                views.put((Object)slot, (Object)wrapper);
            } else {
                wrapper = (SlotViewWrapper)views.get((Object)slot);
            }
            wrapper.setEnableOverlay(wrapper.getView().canSearch() && !this.isSearchedItem(slot.func_75211_c()));
        }
    }

    private boolean isSearchedItem(ItemStack stack) {
        if (emptyFilter) {
            return true;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        for (Object ingredient : JeiModule.filter.getFilteredIngredients()) {
            if (!ItemUtils.ingredientMatches(ingredient, stack)) continue;
            return true;
        }
        return false;
    }

    public void tick() {
        if (!this.canShowIn(Minecraft.func_71410_x().field_71462_r)) {
            return;
        }
        if (enabled && !JeiModule.filter.getFilterText().equals(lastFilterText)) {
            lastFilterText = JeiModule.filter.getFilterText();
            emptyFilter = lastFilterText.replace(" ", "").isEmpty();
        }
        if (enabled && Minecraft.func_71410_x().field_71462_r instanceof GuiContainer) {
            this.checkSlots((GuiContainer)Minecraft.func_71410_x().field_71462_r);
            this.guiOffsetX = GuiUtils.getGuiLeft((GuiContainer)Minecraft.func_71410_x().field_71462_r);
            this.guiOffsetY = GuiUtils.getGuiTop((GuiContainer)Minecraft.func_71410_x().field_71462_r);
        } else if (views != null) {
            views.clear();
        }
    }

    public void toggleMode() {
        boolean bl = enabled = !enabled;
        if (enabled) {
            lastFilterText = JeiModule.filter.getFilterText();
            emptyFilter = lastFilterText.replace(" ", "").isEmpty();
        } else {
            lastFilterText = "";
        }
    }

    public boolean isEnabled() {
        return enabled;
    }
}

