/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world.underground;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import vazkii.quark.base.module.ConfigHelper;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.world.feature.UndergroundBiomes;
import vazkii.quark.world.world.underground.BasicUndergroundBiome;

public class UndergroundBiomeSpiderNest
extends BasicUndergroundBiome {
    public static double floorCobwebChance;
    public static double ceilingCobwebChance;
    public static double caveSpiderSpawnerChance;
    public static double nestCobwebChance;
    public static double nestCobwebRange;
    public static double cobbedstoneChance;

    public UndergroundBiomeSpiderNest() {
        super(Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P());
    }

    @Override
    public void fillCeiling(World world, BlockPos pos, IBlockState state) {
        super.fillCeiling(world, pos, state);
        this.placeCobweb(world, pos, EnumFacing.DOWN, ceilingCobwebChance);
    }

    private void placeCobweb(World world, BlockPos pos, EnumFacing off, double chance) {
        if (world.field_73012_v.nextDouble() < chance) {
            BlockPos placePos = off == null ? pos : pos.func_177972_a(off);
            world.func_175656_a(placePos, Blocks.field_150321_G.func_176223_P());
        }
    }

    @Override
    public void fillWall(World world, BlockPos pos, IBlockState state) {
        if (UndergroundBiomes.cobbedstoneEnabled && world.field_73012_v.nextDouble() < cobbedstoneChance) {
            world.func_180501_a(pos, UndergroundBiomes.cobbedstoneState, 2);
        } else {
            super.fillWall(world, pos, state);
        }
    }

    @Override
    public void fillFloor(World world, BlockPos pos, IBlockState state) {
        if (UndergroundBiomes.cobbedstoneEnabled && world.field_73012_v.nextDouble() < cobbedstoneChance) {
            world.func_180501_a(pos, UndergroundBiomes.cobbedstoneState, 2);
        } else {
            super.fillFloor(world, pos, state);
        }
        this.placeCobweb(world, pos, EnumFacing.UP, floorCobwebChance);
    }

    @Override
    public boolean hasDungeon() {
        return true;
    }

    @Override
    public void spawnDungeon(WorldServer world, BlockPos pos, EnumFacing face) {
        TileEntityMobSpawner spawner;
        BlockPos spawnerPos = pos.func_177972_a(face);
        world.func_175656_a(spawnerPos, Blocks.field_150474_ac.func_176223_P());
        Class<EntitySpider> e = EntitySpider.class;
        if (world.field_73012_v.nextDouble() < caveSpiderSpawnerChance) {
            e = EntityCaveSpider.class;
        }
        if ((spawner = (TileEntityMobSpawner)world.func_175625_s(spawnerPos)) != null) {
            spawner.func_145881_a().func_190894_a(EntityList.func_191306_a(e));
        }
        int range = 3;
        for (int x = -range; x < range + 1; ++x) {
            for (int y = -range; y < range + 1; ++y) {
                for (int z = -range; z < range + 1; ++z) {
                    BlockPos cobwebPos = spawnerPos.func_177982_a(x, y, z);
                    IBlockState stateAt = world.func_180495_p(cobwebPos);
                    if (!stateAt.func_177230_c().isAir(stateAt, (IBlockAccess)world, cobwebPos) && !stateAt.func_177230_c().func_176200_f((IBlockAccess)world, cobwebPos)) continue;
                    this.placeCobweb((World)world, cobwebPos, null, nestCobwebChance);
                }
            }
        }
    }

    @Override
    public void setupConfig(String category) {
        floorCobwebChance = ConfigHelper.loadLegacyPropChance("Floor Cobweb Percentage Chance", category, "Floor Cobweb Chance", "The chance cobwebs will spawn", 0.033);
        ceilingCobwebChance = ConfigHelper.loadLegacyPropChance("Ceiling Cobweb Percentage Chance", category, "Ceiling Cobweb Chance", "The chance ceiling cobwebs will spawn", 0.1);
        caveSpiderSpawnerChance = ConfigHelper.loadLegacyPropChance("Cave Spider Spawner Percentage Chance", category, "Cave Spider Spawner Chance", "The chance for a spider spawner to be a cave spider spawner instead", 0.25);
        nestCobwebChance = ConfigHelper.loadLegacyPropChance("Nest Cobweb Percentage Chance", category, "Nest Cobweb Chance", "The chance cobwebs will spawn in nests", 0.5);
        nestCobwebRange = ModuleLoader.config.getInt("Nest Cobweb Range", category, 3, 0, Integer.MAX_VALUE, "The range for cobwebs to be spawned in spider nests");
        cobbedstoneChance = ConfigHelper.loadPropChance("Cobbedstone Chance", category, "The chance for cobbedstone to replace cobblestone in the floor and walls", 0.3);
    }
}

